/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassWithTooManyTransitiveDependentsInspection
extends BaseGlobalInspection {
    public int limit = 35;

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DEPENDENCY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dependency/ClassWithTooManyTransitiveDependentsInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope analysisScope, InspectionManager inspectionManager, GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        PsiClass aClass = refClass.getElement();
        if (ClassUtils.isInnerClass(aClass)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateTransitiveDependentsForClass(refClass);
        int numDependents = dependencies.size();
        if (numDependents <= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("class.with.too.many.transitive.dependents.problem.descriptor", refEntity.getName(), numDependents, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("class.with.too.many.transitive.dependents.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

