/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.controlflow.LocalVariableAccessVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementWithConfusingDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LocalVariableUsedAndDeclaredInDifferentSwitchBranches" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection.getID must not return null");
        }
        return "LocalVariableUsedAndDeclaredInDifferentSwitchBranches";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.with.confusing.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("switch.statement.with.confusing.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithConfusingDeclarationVisitor();
    }

    private static class SwitchStatementWithConfusingDeclarationVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithConfusingDeclarationVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            PsiStatement[] statements;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/SwitchStatementWithConfusingDeclarationInspection$SwitchStatementWithConfusingDeclarationVisitor.visitSwitchStatement must not be null");
            }
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            HashSet variablesInPreviousBranches = new HashSet(10);
            HashSet<PsiLocalVariable> variablesInCurrentBranch = new HashSet<PsiLocalVariable>(10);
            for (PsiStatement child : statements = body.getStatements()) {
                if (child instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)child;
                    for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiLocalVariable)) continue;
                        PsiLocalVariable localVar = (PsiLocalVariable)declaredElement;
                        variablesInCurrentBranch.add(localVar);
                    }
                }
                if (child instanceof PsiBreakStatement) {
                    variablesInPreviousBranches.addAll(variablesInCurrentBranch);
                    variablesInCurrentBranch.clear();
                }
                LocalVariableAccessVisitor visitor = new LocalVariableAccessVisitor();
                child.accept((PsiElementVisitor)visitor);
                Set<PsiElement> accessedVariables = visitor.getAccessedVariables();
                for (PsiElement accessedVariable : accessedVariables) {
                    PsiLocalVariable localVar = (PsiLocalVariable)accessedVariable;
                    if (!variablesInPreviousBranches.contains(localVar)) continue;
                    variablesInPreviousBranches.remove(localVar);
                    this.registerVariableError((PsiVariable)localVar, new Object[0]);
                }
            }
        }
    }
}

