/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class InfiniteLoopStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/InfiniteLoopStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/InfiniteLoopStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor();
    }

    private static class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        private InfiniteLoopStatementsVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor.visitDoWhileStatement must not be null");
            }
            super.visitDoWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        private void checkStatement(PsiStatement statement) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return;
            }
            if (ControlFlowUtils.statementContainsReturn(statement)) {
                return;
            }
            if (ControlFlowUtils.statementContainsSystemExit(statement)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }
    }
}

