/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeCloneableFix;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;

public class CloneInNonCloneableClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeCloneableFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneInNonCloneableClassVisitor();
    }

    private static class CloneInNonCloneableClassVisitor
    extends BaseInspectionVisitor {
        private CloneInNonCloneableClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection$CloneInNonCloneableClassVisitor.visitMethod must not be null");
            }
            if (!CloneUtils.isClone(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || CloneUtils.isCloneable(containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

