/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import org.jetbrains.annotations.NotNull;

public class MultipleTopLevelClassesInFileInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.top.level.classes.in.file.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleTopLevelClassesInFileVisitor();
    }

    private static class MultipleTopLevelClassesInFileVisitor
    extends BaseInspectionVisitor {
        private MultipleTopLevelClassesInFileVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/MultipleTopLevelClassesInFileInspection$MultipleTopLevelClassesInFileVisitor.visitClass must not be null");
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getParent();
            if (file == null) {
                return;
            }
            int numClasses = 0;
            for (PsiElement child : children = file.getChildren()) {
                if (!(child instanceof PsiClass)) continue;
                ++numClasses;
            }
            if (numClasses <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

