/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class EmptyClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/EmptyClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        Object element = infos[0];
        if (element instanceof PsiAnonymousClass) {
            string = InspectionGadgetsBundle.message("empty.anonymous.class.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/EmptyClassInspection.buildErrorString must not return null");
            return string;
        }
        if (element instanceof PsiClass) {
            string = InspectionGadgetsBundle.message("empty.class.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/EmptyClassInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("empty.class.file.without.class.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/EmptyClassInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyClassVisitor();
    }

    private static class EmptyClassVisitor
    extends BaseInspectionVisitor {
        private EmptyClassVisitor() {
        }

        public void visitFile(PsiFile file) {
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            if (javaFile.getClasses().length != 0) {
                return;
            }
            String fileName = javaFile.getName();
            if ("package-info.java".equals(fileName)) {
                return;
            }
            this.registerError((PsiElement)file, file);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/EmptyClassInspection$EmptyClassVisitor.visitClass must not be null");
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                return;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

