/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

class ParameterClassCheckVisitor
extends JavaRecursiveElementVisitor {
    private final PsiParameter parameter;
    private boolean checked = false;

    ParameterClassCheckVisitor(PsiParameter parameter) {
        this.parameter = parameter;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ParameterClassCheckVisitor.visitElement must not be null");
        }
        if (!this.checked) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ParameterClassCheckVisitor.visitMethodCallExpression must not be null");
        }
        if (this.checked) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"getClass".equals(methodName)) {
            return;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (this.isParameterReference(qualifier)) {
            this.checked = true;
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ParameterClassCheckVisitor.visitInstanceOfExpression must not be null");
        }
        if (this.checked) {
            return;
        }
        super.visitInstanceOfExpression(expression);
        PsiExpression operand = expression.getOperand();
        if (this.isParameterReference(operand)) {
            this.checked = true;
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        if (this.checked) {
            return;
        }
        super.visitTypeCastExpression(expression);
        PsiExpression operand = expression.getOperand();
        if (!this.isParameterReference(operand)) {
            return;
        }
        PsiTryStatement statement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class);
        if (statement == null) {
            return;
        }
        PsiParameter[] parameters = statement.getCatchBlockParameters();
        if (parameters.length < 2) {
            return;
        }
        boolean nullPointerExceptionFound = false;
        boolean classCastExceptionFound = false;
        for (PsiParameter parameter : parameters) {
            PsiType type = parameter.getType();
            if (type.equalsToText("java.lang.NullPointerException")) {
                nullPointerExceptionFound = true;
                if (!classCastExceptionFound) continue;
                break;
            }
            if (!type.equalsToText("java.lang.ClassCastException")) continue;
            classCastExceptionFound = true;
            if (nullPointerExceptionFound) break;
        }
        if (classCastExceptionFound && nullPointerExceptionFound) {
            this.checked = true;
        }
    }

    private boolean isParameterReference(PsiExpression operand) {
        if (operand == null) {
            return false;
        }
        if (!(operand instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression expression = (PsiReferenceExpression)operand;
        PsiElement referent = expression.resolve();
        return referent != null && referent.equals(this.parameter);
    }

    public boolean isChecked() {
        return this.checked;
    }
}

