/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class MalformedRegexInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.regular.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedRegexInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        if (infos.length == 0) {
            string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor1", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedRegexInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor2", infos[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedRegexInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedRegexVisitor();
    }

    private static class MalformedRegexVisitor
    extends BaseInspectionVisitor {
        private MalformedRegexVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MalformedRegexInspection$MalformedRegexVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiExpressionList argList = expression.getArgumentList();
            if (argList == null) {
                return;
            }
            PsiExpression[] args = argList.getExpressions();
            if (args.length == 0) {
                return;
            }
            PsiExpression regexArg = args[0];
            if (!TypeUtils.expressionHasType("java.lang.String", regexArg)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)regexArg)) {
                return;
            }
            PsiType regexType = regexArg.getType();
            String value = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)regexArg, (PsiType)regexType);
            if (value == null) {
                return;
            }
            if (!MethodCallUtils.isCallToRegexMethod(expression)) {
                return;
            }
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                this.registerError((PsiElement)regexArg, e.getDescription());
            }
            catch (NullPointerException e) {
                this.registerError((PsiElement)regexArg, new Object[0]);
            }
        }
    }
}

