/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private static class EqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection$EqualsBetweenInconvertibleTypesVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isEqualsCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression expression1 = args[0];
            PsiExpression expression2 = methodExpression.getQualifierExpression();
            if (expression2 == null) {
                return;
            }
            PsiType comparedType = expression1.getType();
            if (comparedType == null) {
                return;
            }
            PsiType comparisonType = expression2.getType();
            if (comparisonType == null) {
                return;
            }
            if (TypeConversionUtil.areTypesConvertible((PsiType)TypeConversionUtil.erasure((PsiType)comparedType), (PsiType)TypeConversionUtil.erasure((PsiType)comparisonType))) {
                return;
            }
            this.registerMethodCallError(expression, comparedType, comparisonType);
        }
    }
}

