/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CovariantEqualsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("covariant.equals.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CovariantEqualsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("covariant.equals.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CovariantEqualsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CovariantEqualsVisitor();
    }

    private static class CovariantEqualsVisitor
    extends BaseInspectionVisitor {
        private CovariantEqualsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] methods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CovariantEqualsInspection$CovariantEqualsVisitor.visitMethod must not be null");
            }
            String name = method.getName();
            if (!"equals".equals(name)) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType argType = parameters[0].getType();
            if (TypeUtils.isJavaLangObject(argType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (PsiMethod method1 : methods = aClass.getMethods()) {
                if (!CovariantEqualsVisitor.isNonVariantEquals(method1)) continue;
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isNonVariantEquals(PsiMethod method) {
            String name = method.getName();
            if (!"equals".equals(name)) {
                return false;
            }
            PsiParameterList paramList = method.getParameterList();
            PsiParameter[] parameters = paramList.getParameters();
            if (parameters.length != 1) {
                return false;
            }
            PsiType argType = parameters[0].getType();
            return TypeUtils.isJavaLangObject(argType);
        }
    }
}

