/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ComparableImplementedButEqualsNotOverriddenInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToAndEqualsNotPairedVisitor();
    }

    private static class CompareToAndEqualsNotPairedVisitor
    extends BaseInspectionVisitor {
        private CompareToAndEqualsNotPairedVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiMethod[] equalsMethods;
            super.visitClass(aClass);
            PsiMethod[] methods = aClass.findMethodsByName("compareTo", false);
            if (methods.length == 0) {
                return;
            }
            PsiManager manager = aClass.getManager();
            PsiClass comparableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Comparable", aClass.getResolveScope());
            if (comparableClass == null) {
                return;
            }
            if (!aClass.isInheritor(comparableClass, true)) {
                return;
            }
            PsiMethod compareToMethod = comparableClass.getMethods()[0];
            boolean foundCompareTo = false;
            for (PsiMethod method : methods) {
                if (!MethodSignatureUtil.isSuperMethod((PsiMethod)compareToMethod, (PsiMethod)method)) continue;
                foundCompareTo = true;
                break;
            }
            if (!foundCompareTo) {
                return;
            }
            for (PsiMethod equalsMethod : equalsMethods = aClass.findMethodsByName("equals", false)) {
                if (!MethodUtils.isEquals(equalsMethod)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

