/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArrayEqualsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArrayEqualsInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ArrayEqualsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualsVisitor();
    }

    private static class ArrayEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isEqualsCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == 0) {
                return;
            }
            PsiExpression arg = args[0];
            if (arg == null) {
                return;
            }
            PsiType argType = arg.getType();
            if (!(argType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class ArrayEqualsFix
    extends InspectionGadgetsFix {
        private ArrayEqualsFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("equals.called.on.array.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            assert (expression != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            String qualifierText = qualifier.getText();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            String argText = args[0].getText();
            String newExpressionText = "java.util.Arrays.equals(" + qualifierText + ", " + argText + ')';
            ArrayEqualsFix.replaceExpressionAndShorten((PsiExpression)call, newExpressionText);
        }
    }
}

