/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArchaicSystemPropertyAccessInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UseOfArchaicSystemPropertyAccessors" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.getID must not return null");
        }
        return "UseOfArchaicSystemPropertyAccessors";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("archaic.system.property.accessors.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiMethodCallExpression call = (PsiMethodCallExpression)infos[0];
        if (ArchaicSystemPropertyAccessInspection.isIntegerGetInteger(call)) {
            string = InspectionGadgetsBundle.message("archaic.system.property.accessors.problem.descriptor.Integer", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.buildErrorString must not return null");
            return string;
        }
        if (ArchaicSystemPropertyAccessInspection.isLongGetLong(call)) {
            string = InspectionGadgetsBundle.message("archaic.system.property.accessors.problem.descriptor.Long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("archaic.system.property.accessors.problem.descriptor.Boolean", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.buildErrorString must not return null");
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ReplaceWithParseMethodFix(), new ReplaceWithStandardPropertyAccessFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArchaicSystemPropertyAccessVisitor();
    }

    static boolean isIntegerGetInteger(PsiMethodCallExpression expression) {
        return ArchaicSystemPropertyAccessInspection.isCallTo(expression, "java.lang.Integer", "getInteger");
    }

    static boolean isLongGetLong(PsiMethodCallExpression expression) {
        return ArchaicSystemPropertyAccessInspection.isCallTo(expression, "java.lang.Long", "getLong");
    }

    static boolean isBooleanGetBoolean(PsiMethodCallExpression expression) {
        return ArchaicSystemPropertyAccessInspection.isCallTo(expression, "java.lang.Boolean", "getBoolean");
    }

    private static boolean isCallTo(PsiMethodCallExpression expression, String className, @NonNls String methodName) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String expressionMethodName = methodExpression.getReferenceName();
        if (!methodName.equals(expressionMethodName)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String expressionClassName = aClass.getQualifiedName();
        if (expressionClassName == null) {
            return false;
        }
        return className.equals(expressionClassName);
    }

    private static class ArchaicSystemPropertyAccessVisitor
    extends BaseInspectionVisitor {
        private ArchaicSystemPropertyAccessVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection$ArchaicSystemPropertyAccessVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (ArchaicSystemPropertyAccessInspection.isIntegerGetInteger(expression) || ArchaicSystemPropertyAccessInspection.isLongGetLong(expression) || ArchaicSystemPropertyAccessInspection.isBooleanGetBoolean(expression)) {
                this.registerMethodCallError(expression, expression);
            }
        }
    }

    private static class ReplaceWithStandardPropertyAccessFix
    extends InspectionGadgetsFix {
        private ReplaceWithStandardPropertyAccessFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("archaic.system.property.accessors.replace.standard.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection$ReplaceWithStandardPropertyAccessFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier location = (PsiIdentifier)descriptor.getPsiElement();
            PsiElement parent = location.getParent();
            assert (parent != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)parent.getParent();
            assert (call != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            String argText = args[0].getText();
            String parseMethodCall = ArchaicSystemPropertyAccessInspection.isIntegerGetInteger(call) ? "Integer.parseInt(System.getProperty(" + argText + "))" : (ArchaicSystemPropertyAccessInspection.isLongGetLong(call) ? "Long.parseLong(System.getProperty(" + argText + "))" : (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)call) ? "Boolean.valueOf(System.getProperty(" + argText + ")).booleanValue()" : "Boolean.parseBoolean(System.getProperty(" + argText + "))"));
            ReplaceWithStandardPropertyAccessFix.replaceExpression((PsiExpression)call, parseMethodCall);
        }
    }

    private static class ReplaceWithParseMethodFix
    extends InspectionGadgetsFix {
        private ReplaceWithParseMethodFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("archaic.system.property.accessors.replace.parse.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ArchaicSystemPropertyAccessInspection$ReplaceWithParseMethodFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier location = (PsiIdentifier)descriptor.getPsiElement();
            PsiElement parent = location.getParent();
            assert (parent != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)parent.getParent();
            assert (call != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            String argText = args[0].getText();
            String parseMethodCall = ArchaicSystemPropertyAccessInspection.isIntegerGetInteger(call) ? "Integer.valueOf(" + argText + ')' : (ArchaicSystemPropertyAccessInspection.isLongGetLong(call) ? "Long.valueOf(" + argText + ')' : "Boolean.valueOf(" + argText + ')');
            ReplaceWithParseMethodFix.replaceExpression((PsiExpression)call, parseMethodCall);
        }
    }
}

