/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AssignmentToNullInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.null.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToNullInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.null.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToNullInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToNullVisitor();
    }

    private static class AssignmentToNullVisitor
    extends BaseInspectionVisitor {
        private AssignmentToNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            PsiVariable variable;
            PsiReferenceExpression referenceExpression;
            PsiElement element;
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentToNullInspection$AssignmentToNullVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(value);
            String text = value.getText();
            if (!"null".equals(text)) {
                return;
            }
            PsiElement parent = value.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiVariable && AnnotationUtil.isNullable((PsiModifierListOwner)(variable = (PsiVariable)element))) {
                return;
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }
    }
}

