/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.ig.psiutils.LibraryUtil;
import org.jetbrains.annotations.Nullable;

class ConcreteClassUtil {
    private ConcreteClassUtil() {
    }

    public static boolean typeIsConcreteClass(@Nullable PsiTypeElement typeElement) {
        if (typeElement == null) {
            return false;
        }
        PsiType type = typeElement.getType();
        PsiType baseType = type.getDeepComponentType();
        if (!(baseType instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)baseType).resolve();
        if (aClass == null) {
            return false;
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            return false;
        }
        return !LibraryUtil.classIsInLibrary(aClass);
    }
}

