/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.siyeh.ig.InspectionGadgetsPlugin;
import com.siyeh.ig.telemetry.TelemetryToolWindow;
import com.siyeh.ig.telemetry.TelemetryToolWindowImpl;

public class InspectionGadgetsProjectComponent
implements ProjectComponent {
    private TelemetryToolWindow toolWindow = null;
    private boolean telemetryEnabled = true;
    private final Project project;

    public InspectionGadgetsProjectComponent(Project project) {
        this.project = project;
    }

    public void projectOpened() {
        this.telemetryEnabled = InspectionGadgetsPlugin.isTelemetryEnabled();
        if (this.telemetryEnabled) {
            this.toolWindow = new TelemetryToolWindowImpl();
            this.toolWindow.register(this.project);
        }
    }

    public void projectClosed() {
        if (this.telemetryEnabled && this.toolWindow != null) {
            this.toolWindow.unregister(this.project);
        }
    }

    public String getComponentName() {
        return "InspectionGadgetsProjectComponent";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

