/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class UrlClassLoader
extends ClassLoader {
    private final ClassPath myClassPath;
    private final List<URL> myURLs;
    @NonNls
    static final String CLASS_EXTENSION = ".class";
    protected static final boolean myDebugTime = false;
    protected static final long NS_THRESHOLD = 10000000L;

    public UrlClassLoader(ClassLoader parent) {
        this(Arrays.asList(((URLClassLoader)parent).getURLs()), null, true, true);
    }

    public UrlClassLoader(List<URL> urls, ClassLoader parent) {
        this(urls, parent, false, false);
    }

    public UrlClassLoader(URL[] urls, ClassLoader parent) {
        this(Arrays.asList(urls), parent, false, false);
    }

    public UrlClassLoader(List<URL> urls, ClassLoader parent, boolean canLockJars, boolean canUseCache) {
        super(parent);
        this.myClassPath = new ClassPath(urls.toArray(new URL[urls.size()]), canLockJars, canUseCache);
        this.myURLs = new ArrayList<URL>(urls);
    }

    public void addURL(URL url) {
        this.myClassPath.addURL(url);
        this.myURLs.add(url);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.myURLs);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(CLASS_EXTENSION), false);
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Nullable
    protected Class _findClass(String name) {
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(CLASS_EXTENSION), false);
        if (res == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgname;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public URL findResource(String name) {
        long started = 0L;
        try {
            URL uRL = this.findResourceImpl(name);
            return uRL;
        }
        finally {
            long doneFor = 0L;
            if (doneFor > 10000000L) {
                System.out.println(doneFor / 1000000L + " ms for UrlClassLoader.getResource, resource:" + name);
            }
        }
    }

    protected URL findResourceImpl(String name) {
        Resource res = this._getResource(name);
        if (res == null) {
            return null;
        }
        return res.getURL();
    }

    @Nullable
    private Resource _getResource(String name) {
        String n = name;
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return this.myClassPath.getResource(n, true);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        try {
            Resource res = this._getResource(name);
            if (res == null) {
                return null;
            }
            return res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.myClassPath.getResources(name, true);
    }
}

