/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.annotations.NonNls;

public abstract class MappedBufferWrapper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.MappedBufferWrapper");
    @NonNls
    private static final String CLEANER_METHOD_NAME = "cleaner";
    @NonNls
    private static final String CLEAN_METHOD_NAME = "clean";
    protected final File myFile;
    protected final long myPosition;
    protected final long myLength;
    private volatile ByteBuffer myBuffer;
    private static final int MAX_FORCE_ATTEMPTS = 10;
    private static Method CLEAN_METHOD;
    private static Method GET_CLEANER_METHOD;

    public MappedBufferWrapper(File file, long pos, long length) {
        this.myFile = file;
        this.myPosition = pos;
        this.myLength = length;
    }

    protected abstract MappedByteBuffer map();

    public final void unmap() {
        if (!MappedBufferWrapper.unmapMappedByteBuffer142b19(this)) {
            LOG.error("Unmapping failed for: " + this.myFile);
        }
        this.myBuffer = null;
    }

    public ByteBuffer getIfCached() {
        return this.myBuffer;
    }

    public ByteBuffer buf() {
        if (this.myBuffer == null) {
            this.myBuffer = this.map();
        }
        return this.myBuffer;
    }

    private static boolean unmapMappedByteBuffer142b19(MappedBufferWrapper holder) {
        return MappedBufferWrapper.clean(holder.getIfCached());
    }

    public static boolean clean(final ByteBuffer buffer) {
        if (buffer == null) {
            return true;
        }
        if (!MappedBufferWrapper.tryForce(buffer)) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = MappedBufferWrapper.getCleanerMethod(buffer);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, ArrayUtil.EMPTY_OBJECT_ARRAY);
                    if (cleaner == null) {
                        return null;
                    }
                    Method cleanMethod = MappedBufferWrapper.getCleanMethod();
                    cleanMethod.invoke(cleaner, ArrayUtil.EMPTY_OBJECT_ARRAY);
                }
                catch (Exception e) {
                    return buffer;
                }
                return null;
            }
        }) == null;
    }

    public static boolean tryForce(ByteBuffer buffer) {
        for (int i = 0; i < 10; ++i) {
            try {
                ((MappedByteBuffer)buffer).force();
                return true;
            }
            catch (Throwable e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static Method getCleanMethod() throws ClassNotFoundException, NoSuchMethodException {
        Method m = CLEAN_METHOD;
        if (m == null) {
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            CLEAN_METHOD = m = cleanerClass.getMethod(CLEAN_METHOD_NAME, ArrayUtil.EMPTY_CLASS_ARRAY);
        }
        return m;
    }

    private static Method getCleanerMethod(Object buffer) throws NoSuchMethodException {
        Method m = GET_CLEANER_METHOD;
        if (m == null) {
            m = buffer.getClass().getMethod(CLEANER_METHOD_NAME, ArrayUtil.EMPTY_CLASS_ARRAY);
            m.setAccessible(true);
            GET_CLEANER_METHOD = m;
        }
        return m;
    }

    public boolean isMapped() {
        return this.getIfCached() != null;
    }

    public void flush() {
        ByteBuffer buffer = this.getIfCached();
        if (buffer instanceof MappedByteBuffer) {
            MappedBufferWrapper.tryForce(buffer);
        }
    }

    public void dispose() {
        this.unmap();
    }
}

