/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class StringInterner {
    private final MySet mySet = new MySet();

    @NotNull
    public String intern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/StringInterner.intern must not be null");
        }
        String string = this.mySet.intern(name);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/StringInterner.intern must not return null");
        }
        return string;
    }

    public void clear() {
        this.mySet.clear();
    }

    private static class MySet
    extends THashSet<String> {
        private MySet() {
        }

        public String intern(String name) {
            int idx = this.index(name);
            if (idx >= 0) {
                return (String)this._set[idx];
            }
            boolean added = this.add(name);
            assert (added);
            return name;
        }
    }
}

