/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractList;

public class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList();
    private E myHead;
    private FList<E> myTail;
    private int mySize;

    private FList() {
    }

    private FList(E head, FList<E> tail) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = tail.size() + 1;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index > 0) {
            current = current.myTail;
            --index;
        }
        return current.myHead;
    }

    public E getHead() {
        return this.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this);
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }
}

