/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    public ConcurrentWeakValueHashMap(Map<K, V> map) {
        this();
        this.putAll(map);
    }

    public ConcurrentWeakValueHashMap() {
        this.myMap = new ConcurrentHashMap();
    }

    public ConcurrentWeakValueHashMap(int initialCapaciy, float loadFactor, int concurrenycLevel) {
        this.myMap = new ConcurrentHashMap(initialCapaciy, loadFactor, concurrenycLevel);
    }

    public void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            if (this.myMap.get(ref.key) != ref) continue;
            this.myMap.remove(ref.key);
        }
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MyReference<K, V> oldRef = this.myMap.put(key, this.createRef(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    private MyReference<K, V> createRef(K key, V value) {
        return new MyReference<K, V>(key, value, this.myQueue);
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        Object oldVal;
        block3: {
            MyReference<K, V> newRef;
            MyReference<K, V> oldRef;
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.putIfAbsent must not be null");
            }
            do {
                this.processQueue();
                newRef = this.createRef(key, value);
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block3;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return (V)oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.remove must not be null");
        }
        this.processQueue();
        return this.myMap.remove(key, this.createRef(key, value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.replace must not be null");
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.replace must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.replace must not be null");
        }
        this.processQueue();
        return this.myMap.replace(key, this.createRef(key, oldValue), this.createRef(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.replace must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.replace must not be null");
        }
        this.processQueue();
        MyReference<K, V> ref = this.myMap.replace(key, this.createRef(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (K k : t.keySet()) {
            V v = t.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }
            });
        }
        return entries;
    }

    public String toString() {
        String s = "ConcurrentWeakValueHashMap size:" + this.size() + " [";
        for (Object k : this.myMap.keySet()) {
            V v = this.get(k);
            s = s + "'" + k + "': '" + v + "', ";
        }
        s = s + "] ";
        return s;
    }

    private static class MyReference<K, T>
    extends WeakReference<T> {
        private final K key;

        public MyReference(K key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyReference that = (MyReference)o;
            return this.key.equals(that.key) && Comparing.equal(this.get(), that.get());
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

