/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;

public class PatternUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PatternUtil");
    private static final HashMap<String, String> ourEscapeRules = new HashMap();

    private static void escape2(char symbol) {
        ourEscapeRules.put("" + symbol, "\\" + symbol);
    }

    public static String convertToRegex(String mask) {
        List<String> strings = StringUtil.split(mask, "\\");
        StringBuffer pattern = new StringBuffer();
        String separator = "";
        for (String string : strings) {
            string = StringUtil.replace(string, ".", "\\.");
            for (Map.Entry e : ourEscapeRules.entrySet()) {
                string = StringUtil.replace(string, (String)e.getKey(), (String)e.getValue());
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string);
        }
        return pattern.toString();
    }

    public static Pattern fromMask(@NonNls String mask) {
        try {
            return Pattern.compile(PatternUtil.convertToRegex(mask));
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            return Pattern.compile("");
        }
    }

    static {
        ourEscapeRules.put("*", ".*");
        ourEscapeRules.put("?", ".");
        PatternUtil.escape2('+');
        PatternUtil.escape2('(');
        PatternUtil.escape2(')');
        PatternUtil.escape2('[');
        PatternUtil.escape2(']');
        PatternUtil.escape2('/');
        PatternUtil.escape2('^');
        PatternUtil.escape2('$');
        PatternUtil.escape2('{');
        PatternUtil.escape2('}');
        PatternUtil.escape2('|');
    }
}

