/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExecutorsQuery<Result, Parameter>
implements Query<Result> {
    protected final Parameter myParameters;
    private boolean myIsProcessing;

    public AbstractExecutorsQuery(@NotNull Parameter params) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/AbstractExecutorsQuery.<init> must not be null");
        }
        this.myIsProcessing = false;
        this.myParameters = params;
    }

    @NotNull
    public Parameter getParameters() {
        Parameter Parameter2 = this.myParameters;
        if (Parameter2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/AbstractExecutorsQuery.getParameters must not return null");
        }
        return Parameter2;
    }

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach(processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/AbstractExecutorsQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator<Result>(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    public Result[] toArray(Result[] a) {
        this.assertNotProcessing();
        Collection<Result> all = this.findAll();
        return all.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/AbstractExecutorsQuery.forEach must not be null");
        }
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    protected abstract boolean processResults(Processor<Result> var1);
}

