/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.URLUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    public static final int MEGABYTE = 0x100000;
    private static final Logger LOG;
    private static final ThreadLocal<byte[]> BUFFER;
    private static final long CHANNELS_COPYING_LIMIT = 0x500000L;
    private static final Method IO_FILE_CAN_EXECUTE_METHOD;
    private static final Method IO_FILE_SET_WRITABLE_METHOD;
    private static final Method IO_FILE_SET_EXECUTABLE_METHOD;

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtil.getRelativePath(basePath, filePath, File.separatorChar);
    }

    public static String getRelativePath(String basePath, String filePath, char separator) {
        return FileUtil.getRelativePath(basePath, filePath, separator, SystemInfo.isFileSystemCaseSensitive);
    }

    private static String ensureEnds(String s, char endsWith) {
        return StringUtil.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    public static String getRelativePath(String basePath, String filePath, char separator, boolean caseSensitive) {
        int len;
        String filePathToCompare;
        basePath = FileUtil.ensureEnds(basePath, separator);
        int lastSeparatorIndex = 0;
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase();
        String string = filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase();
        if (basePathToCompare.equals(FileUtil.ensureEnds(filePathToCompare, separator))) {
            return ".";
        }
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.isAbsolute must not be null");
        }
        return new File(path).isAbsolute();
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) throws IOException {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    @Nullable
    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    @NotNull
    public static char[] loadFileText(File file) throws IOException {
        char[] cArray = FileUtil.loadFileText(file, null);
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileText must not return null");
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(File file, @NonNls String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtil.loadText(reader, (int)file.length());
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileText must not return null");
            }
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] loadText(Reader reader, int length) throws IOException {
        char[] cArray;
        int count;
        int n;
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadText must not return null");
            return cArray;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        cArray = newChars;
        if (newChars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadText must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] loadFileBytes(File file) throws IOException {
        byte[] bytes;
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (len > 0x6400000L) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileBytes must not return null");
        }
        return bytes;
    }

    @NotNull
    public static byte[] loadBytes(InputStream stream, int length) throws IOException {
        int n;
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadBytes must not return null");
        }
        return bytes;
    }

    @NotNull
    public static byte[] loadBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        while ((n = stream.read(bytes, 0, bytes.length)) > 0) {
            buffer.write(bytes, 0, n);
        }
        buffer.close();
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadBytes must not return null");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadTextAndClose(Reader reader) throws IOException {
        String string = new String(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not return null");
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static char[] adaptiveLoadText(Reader reader) throws IOException {
        int n;
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.adaptiveLoadText must not return null");
        }
        return result;
    }

    @NotNull
    public static byte[] adaptiveLoadBytes(InputStream stream) throws IOException {
        int n;
        byte[] bytes = new byte[4096];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.adaptiveLoadBytes must not return null");
        }
        return result;
    }

    public static File createTempDirectory(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile(@NonNls File dir, @NonNls String prefix, @NonNls String suffix, boolean create) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, dir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    public static File createTempFile(@NonNls String prefix, @NonNls String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.createNewFile();
        return file;
    }

    private static File doCreateTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.doCreateTempFile(prefix, suffix, new File(FileUtil.getTempDirectory()));
    }

    private static File doCreateTempFile(String prefix, String suffix, File dir) throws IOException {
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, dir).getCanonicalFile();
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            break;
        }
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void asyncDelete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.asyncDelete must not be null");
        }
        File tempFile = FileUtil.renameToTempFileOrDelete(file);
        if (tempFile == null) {
            return;
        }
        FileUtil.startDeletionThread(tempFile);
    }

    public static void asyncDelete(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.asyncDelete must not be null");
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        if (!tempFiles.isEmpty()) {
            FileUtil.startDeletionThread(tempFiles.toArray(new File[tempFiles.size()]));
        }
    }

    private static void startDeletionThread(final File ... tempFiles) {
        if (tempFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startDeletionThread must not be null");
        }
        Runnable deleteFilesTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                currentThread.setPriority(1);
                ShutDownTracker.getInstance().registerStopperThread(currentThread);
                try {
                    for (File tempFile : tempFiles) {
                        FileUtil.delete(tempFile);
                    }
                }
                finally {
                    ShutDownTracker.getInstance().unregisterStopperThread(currentThread);
                    currentThread.setPriority(5);
                }
            }
        };
        try {
            Class<?> aClass = Class.forName("com.intellij.openapi.application.ApplicationManager");
            Method getApplicationMethod = aClass.getMethod("getApplication", new Class[0]);
            Object application = getApplicationMethod.invoke(null, new Object[0]);
            Method executeOnPooledThreadMethod = application.getClass().getMethod("executeOnPooledThread", Runnable.class);
            executeOnPooledThreadMethod.invoke(application, deleteFilesTask);
        }
        catch (Exception e) {
            Thread t = new Thread(deleteFilesTask, "File deletion thread");
            t.start();
        }
    }

    private static File renameToTempFileOrDelete(File file) {
        String originalFileName;
        File tempFile;
        File tempDir = new File(FileUtil.getTempDirectory());
        boolean isSameDrive = true;
        if (SystemInfo.isWindows) {
            String tempDirDrive = tempDir.getAbsolutePath().substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    private static File getTempFile(String originalFileName, File parent) {
        int randomSuffix;
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ".__del__")).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file1 : files) {
                if (FileUtil.delete(file1)) continue;
                return false;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete() || !file.exists()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean createParentDirs(File file) {
        String parentDirPath;
        if (!file.exists() && (parentDirPath = file.getParent()) != null) {
            File parentFile = new File(parentDirPath);
            return parentFile.exists() && parentFile.isDirectory() || parentFile.mkdirs();
        }
        return false;
    }

    public static boolean createIfDoesntExist(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtil.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean ensureCanCreateFile(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtil.createIfDoesntExist(file)) {
            return false;
        }
        return FileUtil.delete(file);
    }

    public static void copy(File fromFile, File toFile) throws IOException {
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(File fromFile, File toFile) throws IOException {
        FileUtil.performCopy(fromFile, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCopy(File fromFile, File toFile, boolean syncTimestamp) throws IOException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException e) {
            File parentFile = toFile.getParentFile();
            if (parentFile == null) {
                IOException ioException = new IOException("parent file is null for " + toFile.getPath());
                ioException.initCause(e);
                throw ioException;
            }
            FileUtil.createParentDirs(toFile);
            fos = new FileOutputStream(toFile);
        }
        if (Patches.FILE_CHANNEL_TRANSFER_BROKEN || fromFile.length() > 0x500000L) {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtil.copy(fis, fos);
            }
            finally {
                fis.close();
                fos.close();
            }
        }
        FileChannel fromChannel = new FileInputStream(fromFile).getChannel();
        FileChannel toChannel = fos.getChannel();
        try {
            fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
        }
        finally {
            fromChannel.close();
            toChannel.close();
        }
        if (syncTimestamp) {
            toFile.setLastModified(fromFile.lastModified());
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = BUFFER.get();
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copy(InputStream inputStream, int size, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = BUFFER.get();
        for (int toRead = size; toRead > 0 && (read = inputStream.read(buffer, 0, Math.min(buffer.length, toRead))) >= 0; toRead -= read) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDir(File fromDir, File toDir, boolean copySystemFiles) throws IOException {
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().startsWith(".");
            }
        });
    }

    public static void copyDir(File fromDir, File toDir, @Nullable FileFilter filter) throws IOException {
        toDir.mkdirs();
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(CommonBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(CommonBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file : files) {
            if (filter != null && !filter.accept(file)) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), filter);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    public static String getNameWithoutExtension(File file) {
        return FileUtil.getNameWithoutExtension(file.getName());
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String createSequentFileName(File aParentFolder, @NonNls String aFilePrefix, String aExtension) {
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    public static File findSequentNonexistentFile(File aParentFolder, @NonNls String aFilePrefix, String aExtension) {
        int postfix = 0;
        String ext = 0 == aExtension.length() ? "" : "." + aExtension;
        File candidate = new File(aParentFolder, aFilePrefix + ext);
        while (candidate.exists()) {
            candidate = new File(aParentFolder, aFilePrefix + Integer.toString(++postfix) + ext);
        }
        return candidate;
    }

    public static String toSystemDependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemDependentName must not be null");
        }
        return aFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toSystemIndependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemIndependentName must not be null");
        }
        return aFileName.replace('\\', '/');
    }

    public static String nameToCompare(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.nameToCompare must not be null");
        }
        return (SystemInfo.isFileSystemCaseSensitive ? name : name.toLowerCase()).replace('\\', '/');
    }

    public static String unquote(String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(urlString);
    }

    public static boolean isFilePathAcceptable(File file, @Nullable FileFilter fileFilter) {
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static void rename(File source, File target) throws IOException {
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean startsWith(@NonNls String path, @NonNls String start) {
        return FileUtil.startsWith(path, start, SystemInfo.isFileSystemCaseSensitive);
    }

    public static boolean startsWith(String path, String start, boolean caseSensitive) {
        int length1 = path.length();
        int length2 = start.length();
        if (length2 == 0) {
            return true;
        }
        if (length2 > length1) {
            return false;
        }
        if (!path.regionMatches(!caseSensitive, 0, start, 0, length2)) {
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        char last2 = start.charAt(length2 - 1);
        char next1 = last2 == '/' || last2 == File.separatorChar ? path.charAt(length2 - 1) : path.charAt(length2);
        return next1 == '/' || next1 == File.separatorChar;
    }

    public static boolean pathsEqual(String path1, String path2) {
        return SystemInfo.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    public static int comparePaths(String path1, String path2) {
        return SystemInfo.isFileSystemCaseSensitive ? path1.compareTo(path2) : path1.compareToIgnoreCase(path2);
    }

    public static int pathHashCode(String path) {
        return SystemInfo.isFileSystemCaseSensitive ? path.hashCode() : path.toLowerCase().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getExtension must not be null");
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String string = fileName.substring(index + 1).toLowerCase();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.getExtension must not return null");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not be null");
        }
        if (SystemInfo.isWindows) {
            string = new File(path.replace(File.separatorChar, '/')).getCanonicalPath();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
    }

    public static void collectMatchedFiles(File root, Pattern pattern, List<File> files) {
        FileUtil.collectMatchedFiles(root, root, pattern, files);
    }

    private static void collectMatchedFiles(File absoluteRoot, File root, Pattern pattern, List<File> files) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path = FileUtil.toSystemIndependentName(FileUtil.getRelativePath(absoluteRoot, dir));
                if (!pattern.matcher(path).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    @RegExp
    public static String convertAntToRegexp(String antPattern) {
        return FileUtil.convertAntToRegexp(antPattern, true);
    }

    @RegExp
    public static String convertAntToRegexp(String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (antPattern.startsWith("/") || antPattern.startsWith("\\")) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        return builder.toString();
    }

    public static boolean moveDirWithContent(File fromDir, File toDir) {
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    public static String sanitizeFileName(String name) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= '\u0000' || ch >= '\u00ff') continue;
            if (Character.isLetterOrDigit(ch)) {
                result.append(ch);
                continue;
            }
            result.append("_");
        }
        return result.toString();
    }

    public static boolean canCallCanExecute() {
        return IO_FILE_CAN_EXECUTE_METHOD != null;
    }

    public static boolean canExecute(File file) {
        try {
            return (Boolean)IO_FILE_CAN_EXECUTE_METHOD.invoke((Object)file, new Object[0]);
        }
        catch (Exception e) {
            LOG.error(e);
            return false;
        }
    }

    public static void setReadOnlyAttribute(String path, boolean readOnlyStatus) throws IOException {
        if (IO_FILE_SET_WRITABLE_METHOD != null) {
            try {
                IO_FILE_SET_WRITABLE_METHOD.invoke((Object)new File(path), !readOnlyStatus);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error(e);
            }
            catch (InvocationTargetException e) {
                LOG.error(e);
            }
        }
        Process process = SystemInfo.isWindows ? Runtime.getRuntime().exec(new String[]{"attrib", readOnlyStatus ? "+r" : "-r", path}) : Runtime.getRuntime().exec(new String[]{"chmod", readOnlyStatus ? "u-w" : "u+w", path});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setExectuableAttribute(String path, boolean executableFlag) throws IOException {
        if (IO_FILE_SET_EXECUTABLE_METHOD != null) {
            try {
                IO_FILE_SET_EXECUTABLE_METHOD.invoke((Object)new File(path), executableFlag);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error(e);
            }
            catch (InvocationTargetException e) {
                LOG.error(e);
            }
        }
        if (!SystemInfo.isWindows) {
            Process process = Runtime.getRuntime().exec(new String[]{"chmod", executableFlag ? "u+x" : "u-x", path});
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void writeToFile(File file, byte[] text) throws IOException {
        FileUtil.writeToFile(file, text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] text, boolean append) throws IOException {
        FileUtil.createParentDirs(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, append));
        try {
            ((OutputStream)stream).write(text);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static boolean processFilesRecursively(File root, Processor<File> processor) {
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (!file.isDirectory() || (children = file.listFiles()) == null) continue;
            queue.addAll(Arrays.asList(children));
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        for (String path : paths) {
            File file;
            if (StringUtil.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    static {
        Method method;
        LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");
        BUFFER = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[20480];
            }
        };
        try {
            method = File.class.getDeclaredMethod("canExecute", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_CAN_EXECUTE_METHOD = method;
        try {
            method = File.class.getDeclaredMethod("setWritable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_WRITABLE_METHOD = method;
        try {
            method = File.class.getDeclaredMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_EXECUTABLE_METHOD = method;
    }
}

