/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

public class DiffFragment {
    private final String myText1;
    private final String myText2;
    private boolean myIsModified;

    public DiffFragment(String text1, String text2) {
        this.myText1 = text1;
        this.myText2 = text2;
        this.myIsModified = text1 == null || text2 == null || !text1.equals(text2);
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void setModified(boolean modified) {
        this.myIsModified = modified;
    }

    public String getText1() {
        return this.myText1;
    }

    public String getText2() {
        return this.myText2;
    }

    public boolean isChange() {
        return this.myText1 != null && this.myText2 != null && this.isModified();
    }

    public boolean isEqual() {
        return this.myText1 != null && this.myText2 != null && !this.isModified();
    }

    public static DiffFragment unchanged(String text1, String text2) {
        DiffFragment result = new DiffFragment(text1, text2);
        result.setModified(false);
        return result;
    }

    public boolean isOneSide() {
        return this.myText1 == null || this.myText2 == null;
    }
}

