/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.utils.DuplicatesUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;

public class ExtractMethodUtil {
    static PsiElement calculateAnchorToInsertBefore(GrMemberOwner owner, PsiElement startElement) {
        while (startElement != null && !ExtractMethodUtil.isEnclosingDefinition(owner, startElement)) {
            if (startElement.getParent() instanceof GroovyFile) {
                return startElement.getNextSibling();
            }
            PsiElement parent = (startElement = startElement.getParent()).getParent();
            if (!(parent instanceof GroovyFile) || ((GroovyFile)parent).getScriptClass() != owner) continue;
            return startElement.getNextSibling();
        }
        return startElement == null ? null : startElement.getNextSibling();
    }

    private static boolean isEnclosingDefinition(GrMemberOwner owner, PsiElement startElement) {
        if (owner instanceof GrTypeDefinition) {
            GrTypeDefinition definition = (GrTypeDefinition)owner;
            return startElement.getParent() == definition.getBody();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static GrStatement createResultStatement(ExtractMethodInfoHelper helper, @NotNull String methodName) {
        GrStatement grStatement;
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createResultStatement must not be null");
        }
        String name = helper.getOutputName();
        PsiType type = helper.getOutputType();
        GrStatement[] statements = helper.getStatements();
        GrMethodCallExpression callExpression = ExtractMethodUtil.createMethodCallByHelper(methodName, helper);
        if ((name == null || PsiType.VOID.equals(type)) && !helper.isReturnStatement()) {
            grStatement = callExpression;
            if (grStatement == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createResultStatement must not return null");
            return grStatement;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        if (helper.isReturnStatement()) {
            grStatement = factory.createStatementFromText("return " + callExpression.getText());
            if (grStatement == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createResultStatement must not return null");
            return grStatement;
        }
        if (name != null && ExtractMethodUtil.mustAddVariableDeclaration(statements, name)) {
            grStatement = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, callExpression, type.equalsToText("java.lang.Object") ? null : type, name);
            if (grStatement == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createResultStatement must not return null");
            return grStatement;
        }
        grStatement = factory.createExpressionFromText(name + "= " + callExpression.getText());
        if (grStatement != null) return grStatement;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createResultStatement must not return null");
    }

    static boolean validateMethod(GrMethod method, ExtractMethodInfoHelper helper) {
        ArrayList<String> conflicts = new ArrayList<String>();
        GrMemberOwner owner = helper.getOwner();
        PsiMethod[] methods = (PsiMethod[])ArrayUtil.mergeArrays((Object[])owner.getAllMethods(), (Object[])new PsiMethod[]{method}, PsiMethod.class);
        Map map = DuplicatesUtil.factorDuplicates((PsiElement[])methods, (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMethod>(){

            public int computeHashCode(PsiMethod method) {
                return method.getSignature(PsiSubstitutor.EMPTY).hashCode();
            }

            public boolean equals(PsiMethod method1, PsiMethod method2) {
                return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
            }
        });
        List list = (List)map.get(method);
        if (list == null) {
            return true;
        }
        for (PsiMethod psiMethod : list) {
            if (psiMethod == method) continue;
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return true;
            }
            String message = containingClass instanceof GroovyScriptClass ? GroovyRefactoringBundle.message("method.is.already.defined.in.script", GroovyRefactoringUtil.getMethodSignature(method), CommonRefactoringUtil.htmlEmphasize((String)containingClass.getQualifiedName())) : GroovyRefactoringBundle.message("method.is.already.defined.in.class", GroovyRefactoringUtil.getMethodSignature(method), CommonRefactoringUtil.htmlEmphasize((String)containingClass.getQualifiedName()));
            conflicts.add(message);
        }
        return conflicts.size() <= 0 || ExtractMethodUtil.reportConflicts(conflicts, helper.getProject());
    }

    static boolean reportConflicts(ArrayList<String> conflicts, Project project) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        conflictsDialog.show();
        return conflictsDialog.isOK();
    }

    static void removeOldStatements(GrStatementOwner owner, ExtractMethodInfoHelper helper) throws IncorrectOperationException {
        owner.removeElements(helper.getInnerElements());
    }

    private static boolean mustAddVariableDeclaration(@NotNull GrStatement[] statements, @NotNull String varName) {
        if (statements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.mustAddVariableDeclaration must not be null");
        }
        if (varName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.mustAddVariableDeclaration must not be null");
        }
        for (GrStatement statement : statements) {
            if (!(statement instanceof GrVariableDeclaration)) continue;
            GrVariableDeclaration declaration = (GrVariableDeclaration)statement;
            for (GrVariable variable : declaration.getVariables()) {
                if (!varName.equals(variable.getName())) continue;
                return true;
            }
        }
        return ResolveUtil.resolveProperty(statements[0], varName) == null;
    }

    private static boolean containVariableDeclaration(@NotNull GrStatement[] statements, @NotNull String varName) {
        if (statements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.containVariableDeclaration must not be null");
        }
        if (varName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.containVariableDeclaration must not be null");
        }
        GroovyPsiElement element = ResolveUtil.resolveProperty(statements[0], varName);
        if (element == null) {
            return false;
        }
        for (GrStatement statement : statements) {
            if (!statement.getTextRange().contains(element.getTextRange())) continue;
            return true;
        }
        return false;
    }

    static void renameParameterOccurrences(GrMethod method, ExtractMethodInfoHelper helper) throws IncorrectOperationException {
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return;
        }
        GrStatement[] statements = block.getStatements();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        for (ParameterInfo info : helper.getParameterInfos()) {
            final String oldName = info.getOldName();
            String newName = info.getName();
            final ArrayList result = new ArrayList();
            if (oldName.equals(newName)) continue;
            for (GrStatement statement : statements) {
                statement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        GrReferenceExpression expr;
                        super.visitElement(element);
                        if (element instanceof GrReferenceExpression && !(expr = (GrReferenceExpression)element).isQualified() && oldName.equals(expr.getName())) {
                            result.add(expr);
                        }
                    }
                });
                for (GrExpression expr : result) {
                    expr.replaceWithExpression(factory.createExpressionFromText(newName), false);
                }
            }
        }
    }

    static GrMethod createMethodByHelper(@NotNull String name, ExtractMethodInfoHelper helper) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createMethodByHelper must not be null");
        }
        StringBuffer buffer = new StringBuffer();
        PsiType type = helper.getOutputType();
        PsiPrimitiveType outUnboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
        if (outUnboxed != null) {
            type = outUnboxed;
        }
        String typeText = ExtractMethodUtil.getTypeString(helper, false);
        buffer.append(ExtractMethodUtil.getModifierString(helper));
        buffer.append(typeText);
        buffer.append(name);
        buffer.append("(");
        for (String param : ExtractMethodUtil.getParameterString(helper)) {
            buffer.append(param);
        }
        buffer.append(") { \n");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        String outputName = helper.getOutputName();
        ParameterInfo[] infos = helper.getParameterInfos();
        boolean outputIsParameter = false;
        if (outputName != null) {
            for (ParameterInfo parameterInfo : infos) {
                if (!outputName.equals(parameterInfo.getOldName())) continue;
                outputIsParameter = true;
            }
        }
        if (!(type == PsiType.VOID || outputName == null || outputIsParameter || ExtractMethodUtil.mustAddVariableDeclaration(helper.getStatements(), outputName) || ExtractMethodUtil.containVariableDeclaration(helper.getStatements(), outputName))) {
            GrVariableDeclaration decl = factory.createVariableDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, null, type, outputName);
            buffer.append(decl.getText()).append("\n");
        }
        if (!ExtractMethodUtil.isSingleExpression(helper.getStatements())) {
            for (ParameterInfo parameterInfo : helper.getInnerElements()) {
                buffer.append(parameterInfo.getText());
            }
            if (type != PsiType.VOID && outputName != null) {
                buffer.append("\n return ");
                buffer.append(outputName);
            }
        } else {
            GrExpression expr = (GrExpression)helper.getStatements()[0];
            while (expr instanceof GrParenthesizedExpression) {
                expr = ((GrParenthesizedExpression)expr).getOperand();
            }
            buffer.append(PsiType.VOID.equals(type) ? "" : "return ").append(expr != null ? expr.getText() : "");
        }
        buffer.append("\n}");
        String methodText = buffer.toString();
        GrMethod method = factory.createMethodFromText(methodText);
        assert (method != null);
        return method;
    }

    static String[] getParameterString(ExtractMethodInfoHelper helper) {
        int i = 0;
        ParameterInfo[] infos = helper.getParameterInfos();
        int number = 0;
        for (ParameterInfo info : infos) {
            if (!info.passAsParameter()) continue;
            ++number;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterInfo info : infos) {
            if (!info.passAsParameter()) continue;
            PsiType paramType = info.getType();
            PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)paramType);
            if (unboxed != null) {
                paramType = unboxed;
            }
            String paramTypeText = paramType == null || paramType.equalsToText("java.lang.Object") ? "" : paramType.getCanonicalText() + " ";
            params.add(paramTypeText + info.getName() + (i < number - 1 ? ", " : ""));
            ++i;
        }
        return ArrayUtil.toStringArray(params);
    }

    static String getTypeString(ExtractMethodInfoHelper helper, boolean forPresentation) {
        PsiType type = helper.getOutputType();
        PsiPrimitiveType outUnboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
        if (outUnboxed != null) {
            type = outUnboxed;
        }
        String typeText = forPresentation ? type.getPresentableText() : type.getCanonicalText();
        String returnType = typeText == null || typeText.equals("void") || typeText.equals("Object") || !helper.specifyType() ? "" : typeText;
        typeText = returnType.length() == 0 ? "def " : returnType + " ";
        return typeText;
    }

    static GrStatement[] getStatementsByElements(PsiElement[] elements) {
        ArrayList<GrStatement> statementList = new ArrayList<GrStatement>();
        for (PsiElement element : elements) {
            if (!(element instanceof GrStatement)) continue;
            statementList.add((GrStatement)element);
        }
        return statementList.toArray(new GrStatement[statementList.size()]);
    }

    static PsiElement[] getElementsInOffset(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] elements;
        GrExpression expr = GroovyRefactoringUtil.findElementInRange((GroovyFileBase)file, startOffset, endOffset, GrExpression.class);
        if (expr != null) {
            PsiElement parent = expr.getParent();
            if (expr.getParent() instanceof GrMethodCallExpression || parent instanceof GrIndexProperty) {
                expr = (GrExpression)expr.getParent();
            }
            elements = new PsiElement[]{expr};
        } else {
            elements = GroovyRefactoringUtil.findStatementsInRange(file, startOffset, endOffset, true);
        }
        return elements;
    }

    @Nullable
    static GrMemberOwner getMemberOwner(GrStatement statement) {
        PsiElement parent;
        for (parent = statement.getParent(); parent != null && !(parent instanceof GrMemberOwner); parent = parent.getParent()) {
            if (!(parent instanceof GroovyFileBase)) continue;
            return (GrMemberOwner)((GroovyFileBase)parent).getScriptClass();
        }
        return parent instanceof GrMemberOwner ? (GrMemberOwner)parent : null;
    }

    @Nullable
    static GrStatementOwner getDeclarationOwner(GrStatement statement) {
        PsiElement parent = statement.getParent();
        return parent instanceof GrStatementOwner ? (GrStatementOwner)parent : null;
    }

    static boolean isSingleExpression(GrStatement[] statements) {
        return statements.length == 1 && statements[0] instanceof GrExpression && (!(statements[0].getParent() instanceof GrVariableDeclarationOwner) || !(statements[0] instanceof GrAssignmentExpression));
    }

    static GrMethodCallExpression createMethodCallByHelper(@NotNull String name, ExtractMethodInfoHelper helper) {
        String[] argumentNames;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.createMethodCallByHelper must not be null");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(name).append("(");
        int number = 0;
        for (ParameterInfo info : helper.getParameterInfos()) {
            if (!info.passAsParameter()) continue;
            ++number;
        }
        int i = 0;
        for (String argName : argumentNames = helper.getArgumentNames()) {
            if (argName.length() <= 0) continue;
            buffer.append(argName);
            if (i < number - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append(")");
        String callText = buffer.toString();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        GrExpression expr = factory.createExpressionFromText(callText);
        assert (expr instanceof GrMethodCallExpression);
        return (GrMethodCallExpression)expr;
    }

    static int getCaretOffset(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodUtil.getCaretOffset must not be null");
        }
        if (statement instanceof GrVariableDeclaration) {
            GrExpression initializer;
            GrVariable[] variables = ((GrVariableDeclaration)statement).getVariables();
            if (variables.length > 0 && (initializer = variables[0].getInitializerGroovy()) != null) {
                return initializer.getTextOffset();
            }
        } else if (statement instanceof GrAssignmentExpression) {
            GrExpression value = ((GrAssignmentExpression)statement).getRValue();
            if (value != null) {
                return value.getTextOffset();
            }
        } else if (statement instanceof GrMethodCallExpression) {
            return statement.getTextOffset();
        }
        return statement.getTextOffset();
    }

    static boolean canBeStatic(GrStatement statement) {
        for (PsiElement parent = statement.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof GrMethod)) continue;
            return ((GrMethod)parent).hasModifierProperty("static");
        }
        return false;
    }

    static String getModifierString(ExtractMethodInfoHelper helper) {
        String visibility = helper.getVisibility();
        assert (visibility != null && visibility.length() > 0);
        visibility = visibility.equals("public") ? "" : visibility + " ";
        return visibility + (helper.isStatic() ? "static " : "");
    }

    static boolean isReturnStatement(GrStatement statement, Collection<GrReturnStatement> returnStatements) {
        if (statement instanceof GrReturnStatement) {
            return true;
        }
        if (statement instanceof GrIfStatement) {
            boolean checked = GroovyInlineMethodUtil.checkTailIfStatement((GrIfStatement)statement, returnStatements);
            return checked & returnStatements.size() == 0;
        }
        return false;
    }

    public static enum MethodAccessQualifier {
        PUBLIC,
        PRIVATE,
        PROTECTED;

    }
}

