/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GroovyNamesUtil {
    public static boolean isIdentifier(String text) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (text == null) {
            return false;
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        if (lexer.getTokenType() != GroovyTokenTypes.mIDENT) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }

    public static boolean isKeyword(String text) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        if (lexer.getTokenType() == null || !GroovyTokenTypes.KEYWORDS.contains(lexer.getTokenType())) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }

    public static ArrayList<String> camelizeString(String str) {
        String tempString = str;
        tempString = GroovyNamesUtil.deleteNonLetterFromString(tempString);
        ArrayList<String> camelizedTokens = new ArrayList<String>();
        if (!GroovyNamesUtil.isIdentifier(tempString)) {
            return camelizedTokens;
        }
        String result = GroovyNamesUtil.fromLowerLetter(tempString);
        while (!result.equals("")) {
            result = GroovyNamesUtil.fromLowerLetter(result);
            String temp = "";
            while (result.length() != 0 && !result.substring(0, 1).toUpperCase().equals(result.substring(0, 1))) {
                temp = temp + result.substring(0, 1);
                result = result.substring(1);
            }
            camelizedTokens.add(temp);
        }
        return camelizedTokens;
    }

    static String deleteNonLetterFromString(String tempString) {
        Pattern pattern = Pattern.compile("[^a-zA-Z]");
        Matcher matcher = pattern.matcher(tempString);
        return matcher.replaceAll("");
    }

    static String fromLowerLetter(String str) {
        if (str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String camelToSnake(String string) {
        ArrayList<String> tokens = GroovyNamesUtil.camelizeString(string);
        return StringUtil.join((String[])((String[])ContainerUtil.map2Array(tokens, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.decapitalize((String)s);
            }
        })), (String)"-");
    }
}

