/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.file.impl.JavaFileManagerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrShortClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByName must not be null");
        }
        Collection plainClasses = StubIndex.getInstance().get(GrShortClassNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        Collection<PsiClass> allClasses = this.getAllScriptClasses(name, scope);
        if (allClasses.isEmpty() && plainClasses.isEmpty()) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
            if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByName must not return null");
            return psiClassArray;
        }
        for (PsiElement aClass : plainClasses) {
            if (JavaFileManagerImpl.notClass((PsiElement)aClass)) continue;
            allClasses.add((PsiClass)aClass);
        }
        psiClassArray = allClasses.toArray(new PsiClass[allClasses.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByName must not return null");
    }

    @Nullable
    public PsiClass getClassByFQName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassByFQName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassByFQName must not be null");
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>(StubIndex.getInstance().get(GrFullClassNameIndex.KEY, (Object)name.hashCode(), this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject)));
        Collection<PsiClass> scriptClasses = this.getScriptClassesByFQName(name, scope);
        classes.addAll(scriptClasses);
        for (PsiElement psiElement : classes) {
            if (JavaFileManagerImpl.notClass((PsiElement)psiElement) || !name.equals(((PsiClass)psiElement).getQualifiedName())) continue;
            return (PsiClass)psiElement;
        }
        return null;
    }

    public Collection<PsiClass> getScriptClassesByFQName(final String name, GlobalSearchScope scope) {
        Collection scripts = StubIndex.getInstance().get(GrFullScriptNameIndex.KEY, (Object)name.hashCode(), this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        scripts = ContainerUtil.findAll((Collection)scripts, (Condition)new Condition<GroovyFile>(){

            public boolean value(GroovyFile groovyFile) {
                PsiClass clazz = groovyFile.getScriptClass();
                return groovyFile.isScript() && clazz != null && name.equals(clazz.getQualifiedName());
            }
        });
        return ContainerUtil.map((Iterable)scripts, (Function)new Function<GroovyFile, PsiClass>(){

            public PsiClass fun(GroovyFile groovyFile) {
                return groovyFile.getScriptClass();
            }
        });
    }

    @NotNull
    public PsiClass[] getClassesByFQName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByFQName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByFQName must not be null");
        }
        Collection<PsiClass> result = this.getScriptClassesByFQName(name, scope);
        Collection classes = StubIndex.getInstance().get(GrFullClassNameIndex.KEY, (Object)name.hashCode(), this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        if (!classes.isEmpty()) {
            for (PsiElement psiClass : classes) {
                if (JavaFileManagerImpl.notClass((PsiElement)psiClass) || !name.equals(((PsiClass)psiClass).getQualifiedName())) continue;
                result.add((PsiClass)psiClass);
            }
        }
        PsiClass[] psiClassArray = result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getClassesByFQName must not return null");
        }
        return psiClassArray;
    }

    private Collection<PsiClass> getAllScriptClasses(String name, GlobalSearchScope scope) {
        Collection files = StubIndex.getInstance().get(GrScriptClassNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        files = ContainerUtil.findAll((Collection)files, (Condition)new Condition<GroovyFile>(){

            public boolean value(GroovyFile groovyFile) {
                return groovyFile.isScript();
            }
        });
        return ContainerUtil.map((Iterable)files, (Function)new Function<GroovyFile, PsiClass>(){

            public PsiClass fun(GroovyFile groovyFile) {
                assert (groovyFile.isScript());
                return groovyFile.getScriptClass();
            }
        });
    }

    @NotNull
    public String[] getAllClassNames() {
        Collection classNames = StubIndex.getInstance().getAllKeys(GrShortClassNameIndex.KEY, this.myProject);
        Collection scriptNames = StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject);
        classNames.addAll(scriptNames);
        String[] stringArray = ArrayUtil.toStringArray((Collection)classNames);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllClassNames must not return null");
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllClassNames must not be null");
        }
        Collection classNames = StubIndex.getInstance().getAllKeys(GrShortClassNameIndex.KEY, this.myProject);
        Collection scriptNames = StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject);
        classNames.addAll(scriptNames);
        dest.addAll(classNames);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        PsiMethod[] psiMethodArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByName must not be null");
        }
        Collection methods = StubIndex.getInstance().get(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        Collection annMethods = StubIndex.getInstance().get(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        if (methods.isEmpty() && annMethods.isEmpty()) {
            psiMethodArray = PsiMethod.EMPTY_ARRAY;
            if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByName must not return null");
            return psiMethodArray;
        }
        psiMethodArray = (PsiMethod[])ArrayUtil.mergeArrays((Object[])annMethods.toArray(new PsiMethod[annMethods.size()]), (Object[])methods.toArray(new PsiMethod[methods.size()]), PsiMethod.class);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByName must not return null");
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByNameIfNotMoreThan must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByNameIfNotMoreThan must not be null");
        }
        PsiMethod[] psiMethodArray = this.getMethodsByName(name, scope);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getMethodsByNameIfNotMoreThan must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        String[] stringArray = ArrayUtil.toStringArray((Collection)keys);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllMethodNames must not return null");
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllMethodNames must not be null");
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        PsiField[] psiFieldArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getFieldsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getFieldsByName must not be null");
        }
        Collection fields = StubIndex.getInstance().get(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope, this.myProject));
        if (fields.isEmpty()) {
            psiFieldArray = PsiField.EMPTY_ARRAY;
            if (PsiField.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getFieldsByName must not return null");
            return psiFieldArray;
        }
        psiFieldArray = fields.toArray(new PsiField[fields.size()]);
        if (psiFieldArray != null) return psiFieldArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getFieldsByName must not return null");
    }

    @NotNull
    public String[] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        String[] stringArray = ArrayUtil.toStringArray((Collection)fields);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllFieldNames must not return null");
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache.getAllFieldNames must not be null");
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject));
    }
}

