/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class MethodTypeInferencer
implements Computable<PsiType> {
    private final GrCodeBlock myBlock;

    public MethodTypeInferencer(GrCodeBlock block) {
        this.myBlock = block;
    }

    @Nullable
    public PsiType compute() {
        GrStatement last;
        ArrayList<GrReturnStatement> returns = new ArrayList<GrReturnStatement>();
        MethodTypeInferencer.collectReturns(this.myBlock, returns);
        PsiType result = null;
        PsiManager manager = this.myBlock.getManager();
        for (GrReturnStatement returnStatement : returns) {
            GrExpression value = returnStatement.getReturnValue();
            if (value == null) continue;
            result = MethodTypeInferencer.upperBound(result, value.getType(), manager);
        }
        boolean isObject = returns.size() == 0;
        GrStatement[] statements = this.myBlock.getStatements();
        if (statements.length > 0 && (last = statements[statements.length - 1]) instanceof GrExpression) {
            result = MethodTypeInferencer.upperBound(((GrExpression)last).getType(), result, manager);
            isObject = false;
        }
        if (isObject) {
            return TypesUtil.getJavaLangObject(this.myBlock);
        }
        return result;
    }

    private static PsiType upperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return TypesUtil.getLeastUpperBound(type1, type2, manager);
    }

    private static void collectReturns(PsiElement element, List<GrReturnStatement> returns) {
        if (element instanceof GrReturnStatement) {
            returns.add((GrReturnStatement)element);
        } else {
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                MethodTypeInferencer.collectReturns(child, returns);
            }
        }
    }
}

