/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrBinaryExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrAdditiveExpressionImpl
extends GrBinaryExpressionImpl {
    public GrAdditiveExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrAdditiveExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public PsiType getType() {
        GrExpression lop = this.getLeftOperand();
        PsiType lType = lop.getType();
        PsiType numeric = TypesUtil.getNumericResultType(this, lType);
        if (numeric != null) {
            return numeric;
        }
        IElementType tokenType = this.getOperationTokenType();
        if (tokenType == GroovyTokenTypes.mPLUS) {
            if (GrAdditiveExpressionImpl.isStringType(lType)) {
                return this.getTypeByFQName("java.lang.String");
            }
            GrExpression rop = this.getRightOperand();
            if (rop != null && GrAdditiveExpressionImpl.isStringType(rop.getType())) {
                return this.getTypeByFQName("java.lang.String");
            }
        }
        return null;
    }

    private static boolean isStringType(PsiType type) {
        return type != null && (type.equalsToText("java.lang.String") || type.equalsToText("groovy.lang.GString"));
    }

    public String toString() {
        return "Additive expression";
    }
}

