/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;

public class GrThisReferenceExpressionImpl
extends GrExpressionImpl
implements GrThisReferenceExpression {
    public GrThisReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrThisReferenceExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitThisExpression(this);
    }

    public String toString() {
        return "'this' reference expression";
    }

    @Override
    public PsiType getType() {
        GrReferenceExpression qualifier = this.getQualifier();
        if (qualifier == null) {
            PsiClass scriptClass;
            GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{GrTypeDefinition.class, GroovyFile.class});
            if (context instanceof GrTypeDefinition) {
                return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType((PsiClass)context);
            }
            if (context instanceof GroovyFile && (scriptClass = ((GroovyFile)context).getScriptClass()) != null) {
                return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(scriptClass);
            }
        } else {
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiClass) {
                return new PsiImmediateClassType((PsiClass)resolved, PsiSubstitutor.EMPTY);
            }
            try {
                return JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText(qualifier.getText(), (PsiElement)this);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GrReferenceExpression getQualifier() {
        return (GrReferenceExpression)this.findChildByType(GroovyElementTypes.REFERENCE_EXPRESSION);
    }
}

