/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrBuiltInTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrNewExpressionImpl
extends GrCallExpressionImpl
implements GrNewExpression {
    public GrNewExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "NEW expression";
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitNewExpression(this);
    }

    @Override
    public PsiType getType() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getBaseClassType();
        }
        GrClassReferenceType type = null;
        GrCodeReferenceElement refElement = this.getReferenceElement();
        if (refElement != null) {
            type = new GrClassReferenceType(refElement);
        } else {
            GrBuiltInTypeElement builtin = (GrBuiltInTypeElement)this.findChildByClass(GrBuiltInTypeElement.class);
            if (builtin != null) {
                type = builtin.getType();
            }
        }
        if (type != null) {
            for (int i = 0; i < this.getArrayCount(); ++i) {
                type = type.createArrayType();
            }
            return type;
        }
        return null;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        if (list == null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrArgumentList newList = factory.createExpressionArgumentList(new GrExpression[0]);
            PsiElement last = this.getLastChild();
            while (last.getPrevSibling() instanceof PsiWhiteSpace || last.getPrevSibling() instanceof PsiErrorElement) {
                last = last.getPrevSibling();
            }
            ASTNode astNode = last.getNode();
            assert (astNode != null);
            this.getNode().addChild(newList.getNode(), astNode);
        }
        return super.addNamedArgument(namedArgument);
    }

    @Override
    public GrArgumentList getArgumentList() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getArgumentListGroovy();
        }
        return super.getArgumentList();
    }

    @Override
    @Nullable
    public GrExpression getQualifier() {
        PsiElement[] children;
        for (PsiElement child : children = this.getChildren()) {
            if (child instanceof GrExpression) {
                return (GrExpression)child;
            }
            if (!"new".equals(child.getText())) continue;
            return null;
        }
        return null;
    }

    @Override
    public GrCodeReferenceElement getReferenceElement() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getBaseClassReferenceGroovy();
        }
        return (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] multiResolveConstructor() {
        GroovyResolveResult[] groovyResolveResultArray;
        GrCodeReferenceElement ref = this.getReferenceElement();
        if (ref == null) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.multiResolveConstructor must not return null");
            return groovyResolveResultArray;
        }
        GroovyResolveResult[] classResults = ref.multiResolve(false);
        if (classResults.length == 0) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.multiResolveConstructor must not return null");
            return groovyResolveResultArray;
        }
        if (this.getNamedArguments().length > 0 && this.getArgumentList().getExpressionArguments().length == 0) {
            GroovyResolveResult[] constructorResults;
            for (GroovyResolveResult result : constructorResults = PsiUtil.getConstructorCandidates(ref, classResults, new PsiType[]{PsiUtil.createMapType((PsiManager)this.getManager(), this.getResolveScope())})) {
                PsiMethod constructor;
                PsiParameter[] parameters;
                if (!(result.getElement() instanceof PsiMethod) || (parameters = (constructor = (PsiMethod)result.getElement()).getParameterList().getParameters()).length != 1 || !InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"java.util.Map")) continue;
                groovyResolveResultArray = constructorResults;
                if (constructorResults == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.multiResolveConstructor must not return null");
                return groovyResolveResultArray;
            }
            GroovyResolveResult[] emptyConstructors = PsiUtil.getConstructorCandidates(ref, classResults, PsiType.EMPTY_ARRAY);
            if (emptyConstructors.length > 0) {
                groovyResolveResultArray = emptyConstructors;
                if (emptyConstructors == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.multiResolveConstructor must not return null");
                return groovyResolveResultArray;
            }
        }
        if ((groovyResolveResultArray = PsiUtil.getConstructorCandidates(ref, classResults, PsiUtil.getArgumentTypes(ref, false))) != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.multiResolveConstructor must not return null");
    }

    @Override
    public PsiMethod resolveConstructor() {
        return PsiImplUtil.extractUniqueElement(this.multiResolveConstructor());
    }

    @Override
    public GroovyResolveResult resolveConstructorGenerics() {
        return PsiImplUtil.extractUniqueResult(this.multiResolveConstructor());
    }

    @Override
    public int getArrayCount() {
        GrArrayDeclaration arrayDeclaration = (GrArrayDeclaration)this.findChildByClass(GrArrayDeclaration.class);
        if (arrayDeclaration == null) {
            return 0;
        }
        return arrayDeclaration.getArrayCount();
    }

    @Override
    public GrAnonymousClassDefinition getAnonymousClassDefinition() {
        return (GrAnonymousClassDefinition)this.findChildByClass(GrAnonymousClassDefinition.class);
    }

    @Override
    @Nullable
    public PsiMethod resolveMethod() {
        return this.resolveConstructor();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] getMethodVariants() {
        GroovyResolveResult[] groovyResolveResultArray;
        GrCodeReferenceElement referenceElement = this.getReferenceElement();
        if (referenceElement == null) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.getMethodVariants must not return null");
            return groovyResolveResultArray;
        }
        GroovyResolveResult[] classResults = referenceElement.multiResolve(false);
        ArrayList<GroovyResolveResultImpl> result = new ArrayList<GroovyResolveResultImpl>();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.getProject()).getResolveHelper();
        for (GroovyResolveResult classResult : classResults) {
            PsiMethod[] constructors;
            PsiElement element = classResult.getElement();
            if (!(element instanceof PsiClass)) continue;
            for (PsiMethod constructor : constructors = ((PsiClass)element).getConstructors()) {
                boolean isAccessible = helper.isAccessible((PsiMember)constructor, (PsiElement)this, null);
                result.add(new GroovyResolveResultImpl((PsiElement)constructor, null, classResult.getSubstitutor(), isAccessible, true));
            }
        }
        groovyResolveResultArray = result.toArray(new GroovyResolveResult[result.size()]);
        if (groovyResolveResultArray != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrNewExpressionImpl.getMethodVariants must not return null");
    }
}

