/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public abstract class GrBlockImpl
extends GroovyPsiElementImpl
implements GrCodeBlock,
GrControlFlowOwner {
    private Instruction[] myControlFlow;

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myControlFlow = null;
    }

    @Override
    public Instruction[] getControlFlow() {
        if (this.myControlFlow == null) {
            this.myControlFlow = new ControlFlowBuilder(this.getProject()).buildControlFlow(this, null, null);
        }
        return this.myControlFlow;
    }

    public GrBlockImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.<init> must not be null");
        }
        super(node);
        this.myControlFlow = null;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    private boolean mayUseNewLinesAsSeparators() {
        for (GrBlockImpl parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof GrString)) continue;
            GrString grString = (GrString)((Object)parent);
            return !grString.isPlainString();
        }
        return true;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = (GrStatement[])this.findChildrenByClass(GrStatement.class);
        if (grStatementArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.getStatements must not return null");
        }
        return grStatementArray;
    }

    @Override
    public GrStatement addStatementBefore(@NotNull GrStatement element, GrStatement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.addStatementBefore must not be null");
        }
        if (anchor == null && this.getRBrace() == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        ASTNode elemNode = element.copy().getNode();
        assert (elemNode != null);
        ASTNode anchorNode = anchor != null ? anchor.getNode() : this.getRBrace().getNode();
        this.getNode().addChild(elemNode, anchorNode);
        if (this.mayUseNewLinesAsSeparators()) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mSEMI, (CharSequence)";", anchorNode);
        }
        return (GrStatement)elemNode.getPsi();
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(GroovyTokenTypes.mRCURLY);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl.processDeclarations must not be null");
        }
        return ResolveUtil.processChildren(this, processor, state, lastParent, place);
    }
}

