/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrArgumentListImpl
extends GroovyPsiElementImpl
implements GrArgumentList {
    public GrArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitArgumentList(this);
    }

    public String toString() {
        return "Arguments";
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] grNamedArgumentArray = (GrNamedArgument[])this.findChildrenByClass(GrNamedArgument.class);
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl.getNamedArguments must not return null");
        }
        return grNamedArgumentArray;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrExpression[] grExpressionArray = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (grExpressionArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl.getExpressionArguments must not return null");
        }
        return grExpressionArray;
    }

    @Override
    public GrArgumentList replaceWithArgumentList(GrArgumentList newArgList) throws IncorrectOperationException {
        if (this.getParent() == null || this.getParent().getNode() == null) {
            throw new IncorrectOperationException();
        }
        ASTNode parentNode = this.getParent().getNode();
        ASTNode newNode = newArgList.getNode();
        assert (parentNode != null);
        parentNode.replaceChild(this.getNode(), newNode);
        if (!(newNode.getPsi() instanceof GrArgumentList)) {
            throw new IncorrectOperationException();
        }
        return (GrArgumentList)newNode.getPsi();
    }

    @Override
    public boolean isIndexPropertiesList() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        ASTNode node = firstChild.getNode();
        assert (node != null);
        return node.getElementType() == GroovyTokenTypes.mLBRACK;
    }

    @Override
    @Nullable
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mLPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mRPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    public int getExpressionArgumentIndex(GrExpression arg) {
        for (int i = 0; i < this.getExpressionArguments().length; ++i) {
            GrExpression expression = this.getExpressionArguments()[i];
            if (expression != arg) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Nullable
    public GrExpression removeArgument(int argNumber) {
        for (int i = 0; i < this.getExpressionArguments().length; ++i) {
            ASTNode prev;
            GrExpression expression = this.getExpressionArguments()[i];
            if (i != argNumber) continue;
            ASTNode exprNode = expression.getNode();
            PsiElement prevElem = PsiUtil.getPrevNonSpace(expression);
            PsiElement nextElem = PsiUtil.getNextNonSpace(expression);
            this.getNode().removeChild(exprNode);
            if (nextElem != null && nextElem.getNode() != null && nextElem.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                PsiElement n = nextElem.getNextSibling();
                this.getNode().removeChild(nextElem.getNode());
                if (n != null && n instanceof PsiWhiteSpace) {
                    this.getNode().removeChild(n.getNode());
                }
            } else if (prevElem != null && (prev = prevElem.getNode()) != null && prev.getElementType() == GroovyTokenTypes.mCOMMA) {
                PsiElement p = prevElem.getPrevSibling();
                this.getNode().removeChild(prev);
                this.getNode().removeChild(prevElem.getNode());
                if (p != null && p instanceof PsiWhiteSpace) {
                    this.getNode().removeChild(p.getNode());
                }
            }
            return expression;
        }
        return null;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) {
        GrNamedArgument[] namedArguments = this.getNamedArguments();
        GrExpression[] args = this.getExpressionArguments();
        ASTNode newNode = namedArgument.getNode();
        GroovyPsiElement anchor = null;
        int namedCount = namedArguments.length;
        int exprCount = args.length;
        if (namedCount > 0) {
            anchor = namedArguments[namedCount - 1];
        } else if (exprCount > 0) {
            anchor = args[exprCount - 1];
        }
        anchor = anchor != null ? PsiUtil.getNextNonSpace(anchor) : this.getRightParen();
        if (anchor != null) {
            ASTNode astNode = anchor.getNode();
            this.getNode().addChild(newNode, astNode);
        } else {
            this.getNode().addChild(newNode);
        }
        if (namedCount + exprCount > 0) {
            this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", newNode);
        }
        return namedArgument;
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        PsiElement result;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl.addAfter must not be null");
        }
        GrExpression[] params = this.getExpressionArguments();
        ASTNode astNode = this.getNode();
        if (anchor == null) {
            anchor = this.getLeftParen();
        }
        if (params.length == 0) {
            result = super.addAfter(element, anchor);
        } else {
            result = super.addAfter(element, anchor);
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result.getNode());
        }
        CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat((PsiElement)this);
        return result;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl.deleteChildInternal must not be null");
        }
        ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)GroovyTokenTypes.WHITE_SPACES_OR_COMMENTS);
        if (next != null && next.getElementType() == GroovyTokenTypes.mCOMMA) {
            this.deleteChildInternal(next);
        } else {
            ASTNode prev = TreeUtil.skipElementsBack((ASTNode)child.getTreePrev(), (TokenSet)GroovyTokenTypes.WHITE_SPACES_OR_COMMENTS);
            if (prev != null && prev.getElementType() == GroovyTokenTypes.mCOMMA) {
                this.deleteChildInternal(prev);
            }
        }
        super.deleteChildInternal(child);
    }
}

