/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrAccessorMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrFieldImpl
extends GrVariableBaseImpl<GrFieldStub>
implements GrField {
    private GrAccessorMethod mySetter;
    private GrAccessorMethod[] myGetters;
    private boolean mySetterInitialized;
    private boolean myGettersInitialized;
    private volatile CachedValue<PsiType> myEnhancedType;

    public GrFieldImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.<init> must not be null");
        }
        super(node);
        this.mySetterInitialized = false;
        this.myGettersInitialized = false;
    }

    public GrFieldImpl(GrFieldStub stub) {
        this(stub, (IStubElementType)GroovyElementTypes.FIELD);
    }

    public GrFieldImpl(GrFieldStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
        this.mySetterInitialized = false;
        this.myGettersInitialized = false;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitField(this);
    }

    public String toString() {
        return "Field";
    }

    public void setInitializer(@Nullable PsiExpression psiExpression) throws IncorrectOperationException {
    }

    @Override
    public boolean isDeprecated() {
        boolean byDocTag;
        GrFieldStub stub = (GrFieldStub)this.getStub();
        boolean bl = byDocTag = stub == null ? PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) : stub.isDeprecatedByDocTag();
        if (byDocTag) {
            return true;
        }
        return PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @Override
    public PsiType getTypeGroovy() {
        PsiType type;
        if (this.getDeclaredType() == null && this.getInitializer() == null && (type = GrVariableEnhancer.getEnhancedType(this)) != null) {
            return type;
        }
        return super.getTypeGroovy();
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent().getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isProperty() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isProperty();
        }
        PsiClass clazz = this.getContainingClass();
        if (clazz == null) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        GrModifierList modifierList = this.getModifierList();
        return modifierList == null || !modifierList.hasExplicitVisibilityModifiers();
    }

    @Override
    public GrAccessorMethod getSetter() {
        PsiClass clazz;
        String name;
        GrAccessorMethodImpl setter;
        if (this.mySetterInitialized) {
            return this.mySetter;
        }
        this.mySetter = null;
        if (this.isProperty() && !this.hasModifierProperty("final") && !this.hasContradictingMethods(setter = new GrAccessorMethodImpl(this, true, name = "set" + GroovyPropertyUtils.capitalize(this.getName())), clazz = this.getContainingClass())) {
            this.mySetter = setter;
        }
        this.mySetterInitialized = true;
        return this.mySetter;
    }

    public void clearCaches() {
        this.myGettersInitialized = false;
        this.mySetterInitialized = false;
        this.mySetter = null;
        this.myGetters = GrAccessorMethod.EMPTY_ARRAY;
        this.myEnhancedType = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GrAccessorMethod[] getGetters() {
        GrAccessorMethod[] grAccessorMethodArray;
        if (this.myGettersInitialized) {
            grAccessorMethodArray = this.myGetters;
            if (this.myGetters == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getGetters must not return null");
            return grAccessorMethodArray;
        }
        this.myGetters = GrAccessorMethod.EMPTY_ARRAY;
        if (this.isProperty()) {
            String name = this.getName();
            PsiClass clazz = this.getContainingClass();
            name = GroovyPropertyUtils.capitalize(name);
            GrAccessorMethodImpl getter1 = new GrAccessorMethodImpl(this, false, "get" + name);
            if (!this.hasContradictingMethods(getter1, clazz)) {
                GrAccessorMethodImpl getter2 = null;
                if (PsiType.BOOLEAN.equals(this.getDeclaredType()) && this.hasContradictingMethods(getter2 = new GrAccessorMethodImpl(this, false, "is" + name), clazz)) {
                    getter2 = null;
                }
                this.myGetters = getter2 != null ? new GrAccessorMethod[]{getter1, getter2} : new GrAccessorMethod[]{getter1};
            }
        }
        this.myGettersInitialized = true;
        grAccessorMethodArray = this.myGetters;
        if (this.myGetters != null) return grAccessorMethodArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getGetters must not return null");
    }

    private boolean hasContradictingMethods(GrAccessorMethod proto, PsiClass clazz) {
        PsiField field;
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz instanceof GrTypeDefinition ? ((GrTypeDefinition)clazz).findCodeMethodsBySignature(proto, true) : clazz.findMethodsBySignature((PsiMethod)proto, true)) {
            if (clazz.equals(method.getContainingClass())) {
                return true;
            }
            if (!PsiUtil.isAccessible((PsiElement)clazz, (PsiMember)method) || !method.hasModifierProperty("final")) continue;
            return true;
        }
        PsiClass aSuper = clazz.getSuperClass();
        return aSuper != null && (field = aSuper.findFieldByName(this.getName(), true)) instanceof GrField && ((GrField)field).isProperty() && field.hasModifierProperty("final");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope;
        if (this.isProperty()) {
            searchScope = this.getManager().getFileManager().getUseScope((PsiElement)this);
            if (searchScope == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getUseScope must not return null");
            return searchScope;
        }
        searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getUseScope must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string;
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getName must not return null");
            return string;
        }
        string = super.getName();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getName must not return null");
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return GrFieldImpl.this.getName();
            }

            @Nullable
            public String getLocationString() {
                PsiClass clazz = GrFieldImpl.this.getContainingClass();
                if (clazz == null) {
                    return "";
                }
                String name = clazz.getQualifiedName();
                assert (name != null);
                return "(in " + name + ")";
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return GrFieldImpl.this.getIcon(3);
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        Icon superIcon = GroovyIcons.FIELD;
        if (!this.isProperty()) {
            return superIcon;
        }
        LayeredIcon rowIcon = new LayeredIcon(2);
        rowIcon.setIcon(superIcon, 0);
        rowIcon.setIcon(GroovyIcons.DEF, 1);
        return rowIcon;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<String>[] getNamedParametersArray() {
        Set<String>[] setArray;
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            setArray = stub.getNamedParameters();
            if (setArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getNamedParametersArray must not return null");
            return setArray;
        }
        GrExpression initializerGroovy = this.getInitializerGroovy();
        if (!(initializerGroovy instanceof GrClosableBlock)) {
            setArray = GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY;
            if (GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getNamedParametersArray must not return null");
            return setArray;
        }
        GrClosableBlock closure = (GrClosableBlock)initializerGroovy;
        PsiParameter[] parameters = closure.getAllParameters();
        Set[] res = new Set[parameters.length];
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (int i = 0; i < parameters.length; ++i) {
            HashSet set;
            res[i] = set = new HashSet();
            map.put(parameters[i].getName(), set);
        }
        closure.accept(new GrNamedArgumentSearchVisitor(map));
        setArray = res;
        if (res != null) return setArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrFieldImpl.getNamedParametersArray must not return null");
    }

    @Override
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }
}

