/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrAnnotationNameValuePairImpl
extends GroovyPsiElementImpl
implements GrAnnotationNameValuePair,
PsiReference {
    public GrAnnotationNameValuePairImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotationNameValuePair(this);
    }

    public String toString() {
        return "Annotation member value pair";
    }

    @Nullable
    public String getName() {
        PsiElement nameId = this.getNameIdentifierGroovy();
        return nameId != null ? nameId.getText() : null;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifierGroovy() {
        return this.findChildByType(GroovyElementTypes.mIDENT);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public GrAnnotationMemberValue getValue() {
        return (GrAnnotationMemberValue)this.findChildByClass(GrAnnotationMemberValue.class);
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.setValue must not be null");
        }
        this.getValue().replace((PsiElement)newValue);
        GrAnnotationMemberValue grAnnotationMemberValue = this.getValue();
        if (grAnnotationMemberValue == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.setValue must not return null");
        }
        return grAnnotationMemberValue;
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement nameId = this.getNameIdentifierGroovy();
        if (nameId != null) {
            return nameId.getTextRange().shiftRight(-this.getTextRange().getStartOffset());
        }
        return new TextRange(0, 0);
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement resolved;
        GrCodeReferenceElement ref;
        GrAnnotation anno = this.getAnnotation();
        if (anno != null && (ref = anno.getClassReference()) != null && (resolved = ref.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            String declaredName = this.getName();
            String name = declaredName == null ? "value" : declaredName;
            PsiMethod[] methods = ((PsiClass)resolved).findMethodsByName(name, false);
            return methods.length == 1 ? methods[0] : null;
        }
        return null;
    }

    private GrAnnotation getAnnotation() {
        PsiElement pParent = this.getParent().getParent();
        if (pParent instanceof GrAnnotation) {
            return (GrAnnotation)pParent;
        }
        PsiElement ppParent = pParent.getParent();
        return ppParent instanceof GrAnnotation ? (GrAnnotation)ppParent : null;
    }

    public String getCanonicalText() {
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getNameIdentifierGroovy();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null);
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            assert (node != null);
            this.getNode().replaceChild(node, newNameNode);
        } else {
            PsiElement first = this.getFirstChild();
            ASTNode anchorBefore = first != null ? first.getNode() : null;
            this.getNode().addLeaf(GroovyElementTypes.mASSIGN, (CharSequence)"=", anchorBefore);
            this.getNode().addChild(newNameNode, anchorBefore);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException("NYI");
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiMethod && this.getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        PsiElement resolved;
        GrCodeReferenceElement ref;
        GrAnnotation anno = this.getAnnotation();
        if (anno != null && (ref = anno.getClassReference()) != null && (resolved = ref.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            objectArray = ((PsiClass)resolved).getMethods();
            if (objectArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.getVariants must not return null");
            return objectArray;
        }
        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationNameValuePairImpl.getVariants must not return null");
    }

    public boolean isSoft() {
        return false;
    }
}

