/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapImpl
extends GrExpressionImpl
implements GrListOrMap {
    private static final TokenSet MAP_LITERAL_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.ARGUMENT, GroovyTokenTypes.mCOLON});
    private static final Function<GrListOrMapImpl, PsiType> TYPES_CALCULATOR = new MyTypesCalculator();

    public GrListOrMapImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitListOrMap(this);
    }

    public String toString() {
        return "Generalized list";
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        GrExpression[] initializers = this.getInitializers();
        if (initializers.length == 0) {
            return super.addInternal(first, last, this.getNode().getFirstChildNode(), Boolean.valueOf(false));
        }
        ASTNode lastChild = this.getNode().getLastChildNode();
        this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", lastChild);
        return super.addInternal(first, last, lastChild.getTreePrev(), Boolean.valueOf(false));
    }

    @Override
    public PsiType getType() {
        return GroovyPsiManager.getInstance(this.getProject()).getType(this, TYPES_CALCULATOR);
    }

    @Override
    public boolean isMap() {
        return this.findChildByType(MAP_LITERAL_TOKEN_SET) != null;
    }

    @Override
    @NotNull
    public GrExpression[] getInitializers() {
        GrExpression[] grExpressionArray = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (grExpressionArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl.getInitializers must not return null");
        }
        return grExpressionArray;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] grNamedArgumentArray = (GrNamedArgument[])this.findChildrenByClass(GrNamedArgument.class);
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrListOrMapImpl.getNamedArguments must not return null");
        }
        return grNamedArgumentArray;
    }

    private static class MyTypesCalculator
    implements Function<GrListOrMapImpl, PsiType> {
        private MyTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrListOrMapImpl listOrMap) {
            PsiType declaredType;
            GrTypeElement typeElement;
            GlobalSearchScope scope = listOrMap.getResolveScope();
            if (listOrMap.isMap()) {
                return MyTypesCalculator.inferMapInitializerType(listOrMap, JavaPsiFacade.getInstance((Project)listOrMap.getProject()), scope);
            }
            PsiElement parent = listOrMap.getParent();
            if (parent.getParent() instanceof GrVariableDeclaration && (typeElement = ((GrVariableDeclaration)parent.getParent()).getTypeElementGroovy()) != null && (declaredType = typeElement.getType()) instanceof PsiArrayType) {
                return declaredType;
            }
            return MyTypesCalculator.getTupleType(listOrMap.getInitializers(), listOrMap);
        }

        @Nullable
        private static PsiClassType inferMapInitializerType(GrListOrMapImpl listOrMap, JavaPsiFacade facade, GlobalSearchScope scope) {
            GrNamedArgument[] namedArgs;
            HashMap<String, PsiType> stringEntries = new HashMap<String, PsiType>();
            ArrayList<Pair<PsiType, PsiType>> otherEntries = new ArrayList<Pair<PsiType, PsiType>>();
            for (GrNamedArgument namedArg : namedArgs = listOrMap.getNamedArguments()) {
                GrArgumentLabel label = namedArg.getLabel();
                GrExpression expression = namedArg.getExpression();
                if (label == null || expression == null) continue;
                String name = label.getName();
                if (name != null) {
                    stringEntries.put(name, expression.getType());
                    continue;
                }
                otherEntries.add((Pair<PsiType, PsiType>)Pair.create((Object)label.getLabelType(), (Object)expression.getType()));
            }
            return new GrMapType(facade, scope, stringEntries, otherEntries);
        }

        private static PsiClassType getTupleType(GrExpression[] initializers, GrListOrMap listOrMap) {
            PsiType[] result = new PsiType[initializers.length];
            boolean isLValue = PsiUtil.isLValue(listOrMap);
            for (int i = 0; i < result.length; ++i) {
                result[i] = isLValue ? initializers[i].getNominalType() : initializers[i].getType();
            }
            return new GrTupleType(result, JavaPsiFacade.getInstance((Project)listOrMap.getProject()), listOrMap.getResolveScope());
        }
    }
}

