/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.members;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.ThrowClause;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifier;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor.ConstructorBody;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ConstructorDefinition
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, String className, GroovyParser parser) {
        if (className == null) {
            return false;
        }
        PsiBuilder.Marker constructorMarker = builder.mark();
        if (!ConstructorDefinition.parseModifiers(builder, parser)) {
            constructorMarker.rollbackTo();
            return false;
        }
        if (builder.getTokenType() != mIDENT || !className.equals(builder.getTokenText())) {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            constructorMarker.rollbackTo();
            return false;
        }
        builder.advanceLexer();
        if (!ParserUtils.getToken(builder, mLPAREN)) {
            builder.error(GroovyBundle.message("lparen.expected", new Object[0]));
        }
        ParameterList.parse(builder, mRPAREN, parser);
        ParserUtils.getToken(builder, mNLS);
        if (!ParserUtils.getToken(builder, mRPAREN)) {
            constructorMarker.rollbackTo();
            return false;
        }
        if (ParserUtils.lookAhead(builder, mNLS, kTHROWS) || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
            ParserUtils.getToken(builder, mNLS);
        }
        ThrowClause.parse(builder);
        if (builder.getTokenType() == mLCURLY || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
            ParserUtils.getToken(builder, mNLS);
            if (ConstructorBody.parse(builder, parser)) {
                constructorMarker.done((IElementType)CONSTRUCTOR_DEFINITION);
                return true;
            }
        }
        constructorMarker.rollbackTo();
        return false;
    }

    private static boolean parseModifiers(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker modifiersMarker = builder.mark();
        do {
            if (kSTATIC.equals(builder.getTokenType())) {
                modifiersMarker.rollbackTo();
                return false;
            }
            ParserUtils.getToken(builder, mNLS);
        } while (Annotation.parse(builder, parser) || Modifier.parse(builder) || ParserUtils.getToken(builder, kDEF));
        modifiersMarker.done((IElementType)MODIFIERS);
        return true;
    }
}

