/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.BinaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ShiftExpression
implements GroovyElementTypes {
    private static final TokenSet RANGES = TokenSet.create((IElementType[])new IElementType[]{mRANGE_EXCLUSIVE, mRANGE_INCLUSIVE});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (BinaryExpression.ADDITIVE.parseBinary(builder, parser)) {
            GroovyElementType shiftOrRange = ShiftExpression.isRangeOrShift(builder);
            if (!((Object)((Object)shiftOrRange)).equals((Object)WRONGWAY)) {
                if (ParserUtils.getToken(builder, RANGES) || ShiftExpression.getCompositeSign(builder)) {
                    ParserUtils.getToken(builder, mNLS);
                    if (!BinaryExpression.ADDITIVE.parseBinary(builder, parser)) {
                        builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                    }
                    PsiBuilder.Marker newMarker = marker.precede();
                    marker.done((IElementType)shiftOrRange);
                    shiftOrRange = ShiftExpression.isRangeOrShift(builder);
                    if (RANGES.contains(builder.getTokenType()) || ShiftExpression.getCompositeSign(builder)) {
                        ShiftExpression.subParse(builder, newMarker, shiftOrRange, parser);
                    } else {
                        newMarker.drop();
                    }
                } else {
                    marker.drop();
                }
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private static boolean getCompositeSign(PsiBuilder builder) {
        if (ParserUtils.lookAhead(builder, mGT, mGT, mGT)) {
            PsiBuilder.Marker marker = builder.mark();
            for (int i = 0; i < 3; ++i) {
                builder.getTokenText();
                builder.advanceLexer();
            }
            marker.done((IElementType)COMPOSITE_SHIFT_SIGN);
            return true;
        }
        if (ParserUtils.lookAhead(builder, mLT, mLT) || ParserUtils.lookAhead(builder, mGT, mGT)) {
            PsiBuilder.Marker marker = builder.mark();
            for (int i = 0; i < 2; ++i) {
                builder.getTokenText();
                builder.advanceLexer();
            }
            marker.done((IElementType)COMPOSITE_SHIFT_SIGN);
            return true;
        }
        return false;
    }

    private static GroovyElementType isRangeOrShift(PsiBuilder builder) {
        if (RANGES.contains(builder.getTokenType())) {
            return RANGE_EXPRESSION;
        }
        PsiBuilder.Marker marker = builder.mark();
        if (ShiftExpression.getCompositeSign(builder)) {
            marker.rollbackTo();
            return SHIFT_EXPRESSION;
        }
        marker.rollbackTo();
        return WRONGWAY;
    }

    private static void subParse(PsiBuilder builder, PsiBuilder.Marker marker, GroovyElementType shiftOrRange, GroovyParser parser) {
        ParserUtils.getToken(builder, RANGES);
        ParserUtils.getToken(builder, mNLS);
        if (!BinaryExpression.ADDITIVE.parseBinary(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)shiftOrRange);
        GroovyElementType newShiftOrRange = ShiftExpression.isRangeOrShift(builder);
        if (RANGES.contains(builder.getTokenType()) || ShiftExpression.getCompositeSign(builder)) {
            ShiftExpression.subParse(builder, newMarker, newShiftOrRange, parser);
        } else {
            newMarker.drop();
        }
    }
}

