/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.VariableDefinitions;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeParameters;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Declaration
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, boolean isInClass, GroovyParser parser) {
        return Declaration.parse(builder, isInClass, false, parser);
    }

    public static boolean parse(PsiBuilder builder, boolean isInClass, boolean isInAnnotation, GroovyParser parser) {
        PsiBuilder.Marker declMarker = builder.mark();
        boolean modifiersParsed = Modifiers.parse(builder, parser);
        if (modifiersParsed && mLT == builder.getTokenType()) {
            TypeParameters.parse(builder);
            PsiBuilder.Marker checkMarker = builder.mark();
            if (!TypeSpec.parse(builder, true)) {
                checkMarker.rollbackTo();
            } else {
                checkMarker.drop();
            }
            IElementType decl = VariableDefinitions.parseDefinitions(builder, isInClass, false, false, true, modifiersParsed, false, parser);
            if (((Object)((Object)WRONGWAY)).equals(decl)) {
                declMarker.error(GroovyBundle.message("method.definitions.expected", new Object[0]));
            } else {
                declMarker.done((IElementType)METHOD_DEFINITION);
            }
            return true;
        }
        if (modifiersParsed) {
            PsiBuilder.Marker checkMarker = builder.mark();
            if (!TypeSpec.parse(builder, false)) {
                IElementType varDecl;
                checkMarker.rollbackTo();
                if (isInAnnotation) {
                    builder.error(GroovyBundle.message("type.expected", new Object[0]));
                }
                if (((Object)((Object)WRONGWAY)).equals(varDecl = VariableDefinitions.parse(builder, isInClass, modifiersParsed, parser))) {
                    declMarker.rollbackTo();
                    builder.error(GroovyBundle.message("variable.definitions.expected", new Object[0]));
                    return false;
                }
                declMarker.done(varDecl);
                return true;
            }
            IElementType varDeclarationTop = VariableDefinitions.parse(builder, isInClass, modifiersParsed, false, parser);
            if (((Object)((Object)WRONGWAY)).equals(varDeclarationTop)) {
                IElementType varDecl;
                checkMarker.rollbackTo();
                if (isInAnnotation) {
                    builder.error(GroovyBundle.message("type.expected", new Object[0]));
                }
                if (((Object)((Object)WRONGWAY)).equals(varDecl = VariableDefinitions.parse(builder, isInClass, modifiersParsed, false, parser))) {
                    builder.error(GroovyBundle.message("variable.definitions.expected", new Object[0]));
                    declMarker.rollbackTo();
                    return false;
                }
                declMarker.done(varDecl);
                return true;
            }
            checkMarker.drop();
            declMarker.done(varDeclarationTop);
            return true;
        }
        String text = builder.getTokenText();
        if (!(builder.eof() || TokenSets.BUILT_IN_TYPE.contains(builder.getTokenType()) || text == null || !Character.isLowerCase(text.charAt(0)) && Character.isLetter(text.charAt(0)) || !ParserUtils.lookAhead(builder, mIDENT, mIDENT) && !ParserUtils.lookAhead(builder, mIDENT, mLPAREN))) {
            declMarker.rollbackTo();
            return false;
        }
        boolean typeParsed = false;
        if (!ParserUtils.lookAhead(builder, mIDENT, mLPAREN) && !(typeParsed = TypeSpec.parse(builder, true))) {
            builder.error(GroovyBundle.message("type.specification.expected", new Object[0]));
            declMarker.rollbackTo();
            return false;
        }
        IElementType varDef = VariableDefinitions.parseDefinitions(builder, isInClass, false, false, false, typeParsed, false, parser);
        if (varDef != WRONGWAY) {
            declMarker.done(varDef);
            return true;
        }
        if (isInClass && typeParsed) {
            declMarker.drop();
            return typeParsed;
        }
        declMarker.rollbackTo();
        return false;
    }
}

