/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class GrDocTagImpl
extends GroovyDocPsiElementImpl
implements GrDocTag {
    private static final TokenSet VALUE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN, GroovyElementTypes.GDOC_METHOD_REF, GroovyElementTypes.GDOC_FIELD_REF, GroovyElementTypes.GDOC_PARAM_REF, GroovyElementTypes.GDOC_REFERENCE_ELEMENT, GroovyDocTokenTypes.mGDOC_COMMENT_DATA, GroovyElementTypes.GDOC_INLINED_TAG});

    public GrDocTagImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocTagImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitDocTag(this);
    }

    public String toString() {
        return "GroovyDocTag";
    }

    @NotNull
    public String getName() {
        String string = this.getNameElement().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocTagImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiElement getNameElement() {
        PsiElement element = this.findChildByType(GroovyDocTokenTypes.mGDOC_TAG_NAME);
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocTagImpl.getNameElement must not return null");
        }
        return psiElement;
    }

    @Override
    public GrDocComment getContainingComment() {
        return (GrDocComment)this.getParent();
    }

    @Override
    public GrDocTagValueToken getValueElement() {
        GrDocParameterReference reference = (GrDocParameterReference)this.findChildByClass(GrDocParameterReference.class);
        if (reference == null) {
            return null;
        }
        return reference.getReferenceNameElement();
    }

    public PsiElement[] getDataElements() {
        List list = this.findChildrenByType(VALUE_BIT_SET);
        return list.toArray(new PsiElement[list.size()]);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocTagImpl.setName must not be null");
        }
        PsiElement nameElement = this.getNameElement();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GrDocComment comment = factory.createDocCommentFromText("/** @" + name + "*/");
        nameElement.replace(comment.getTags()[0].getNameElement());
        return this;
    }
}

