/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.peer.PeerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocElementType;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocElementTypeImpl;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocLexer;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocParser;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentImpl;

public interface GroovyDocElementTypes
extends GroovyDocTokenTypes {
    public static final ILazyParseableElementType GROOVY_DOC_COMMENT = new ILazyParseableElementType("GrDocComment"){

        @NotNull
        public Language getLanguage() {
            Language language = GroovyFileType.GROOVY_FILE_TYPE.getLanguage();
            if (language == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/parser/GroovyDocElementTypes$1.getLanguage must not return null");
            }
            return language;
        }

        public ASTNode parseContents(ASTNode chameleon) {
            PeerFactory factory = PeerFactory.getInstance();
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = JavaPsiFacade.getInstance((Project)parentElement.getProject()).getProject();
            PsiBuilder builder = factory.createBuilder(chameleon, (Lexer)new GroovyDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText(), project);
            GroovyDocParser parser = new GroovyDocParser();
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }

        public ASTNode createNode(CharSequence text) {
            return new GrDocCommentImpl(text);
        }
    };
    public static final GroovyDocElementType GDOC_TAG = new GroovyDocElementTypeImpl("GroovyDocTag");
    public static final GroovyDocElementType GDOC_INLINED_TAG = new GroovyDocElementTypeImpl("GroovyDocInlinedTag");
    public static final GroovyDocElementType GDOC_REFERENCE_ELEMENT = new GroovyDocElementTypeImpl("GroovyDocReferenceElement");
    public static final GroovyDocElementType GDOC_PARAM_REF = new GroovyDocElementTypeImpl("GroovyDocParameterReference");
    public static final GroovyDocElementType GDOC_METHOD_REF = new GroovyDocElementTypeImpl("GroovyDocMethodReference");
    public static final GroovyDocElementType GDOC_FIELD_REF = new GroovyDocElementTypeImpl("GroovyDocFieldReference");
    public static final GroovyDocElementType GDOC_METHOD_PARAMS = new GroovyDocElementTypeImpl("GroovyDocMethodParameterList");
    public static final GroovyDocElementType GDOC_METHOD_PARAMETER = new GroovyDocElementTypeImpl("GroovyDocMethodParameter");
}

