/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.completion.filters.InlinedTagNameFilter;
import org.jetbrains.plugins.groovy.lang.groovydoc.completion.filters.SimpleTagNameFilter;

public class GroovyDocCompletionData
extends CompletionData {
    private static final String[] INLINED_DOC_TAGS = new String[]{"code", "docRoot", "inheritDoc", "link", "linkplain", "literal"};
    private static final String[] DOC_TAGS = new String[]{"author", "deprecated", "exception", "param", "return", "see", "serial", "serialData", "serialField", "since", "throws", "version"};

    public GroovyDocCompletionData() {
        this.registerAllCompletions();
    }

    private void registerAllCompletions() {
        this.registerTagNameCompletion();
    }

    private void registerTagNameCompletion() {
        this.registerStandardCompletion(new SimpleTagNameFilter(), DOC_TAGS);
        this.registerStandardCompletion(new InlinedTagNameFilter(), INLINED_DOC_TAGS);
    }

    private void registerStandardCompletion(ElementFilter filter, String ... keywords) {
        LeftNeighbour afterDotFilter = new LeftNeighbour((ElementFilter)new TextFilter("."));
        CompletionVariant variant = new CompletionVariant((ElementFilter)new AndFilter((ElementFilter)new NotFilter((ElementFilter)afterDotFilter), filter));
        variant.includeScopeClass(LeafPsiElement.class);
        variant.addCompletionFilter(TrueFilter.INSTANCE);
        this.addCompletions(variant, keywords);
        this.registerVariant(variant);
    }

    private void addCompletions(CompletionVariant variant, String ... comps) {
        for (String completion : comps) {
            variant.addCompletion(completion, TailType.SPACE);
        }
    }
}

