/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GrForBodyFixer
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        GrForStatement forStatement = GrForBodyFixer.getForStatementParent(psiElement);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        GrStatement body = forStatement.getBody();
        if (body instanceof GrBlockStatement) {
            return;
        }
        if (body != null && GrForBodyFixer.startLine(doc, body) == GrForBodyFixer.startLine(doc, forStatement)) {
            return;
        }
        PsiElement eltToInsertAfter = forStatement.getRParenth();
        String text = "{}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text = "){}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    @Nullable
    private static GrForStatement getForStatementParent(PsiElement psiElement) {
        GrForStatement statement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrForStatement.class);
        if (statement == null) {
            return null;
        }
        return statement;
    }

    private static boolean isValidChild(PsiElement ancestor, PsiElement psiElement) {
        if (ancestor != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)psiElement, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

