/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.getters;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.util.ArrayUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class SuggestedVariableNamesGetter
implements ContextGetter {
    public Object[] get(PsiElement context, CompletionContext completionContext) {
        PsiType type;
        GrVariable variable;
        PsiElement parent;
        if (context != null && (parent = context.getParent()) instanceof GrVariable && context.equals((variable = (GrVariable)parent).getNameIdentifierGroovy()) && (type = variable.getTypeGroovy()) != null) {
            String newName;
            Object name;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
            VariableKind kind = variable instanceof GrParameter ? VariableKind.PARAMETER : (variable instanceof GrField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE);
            SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(kind, null, null, type);
            Object[] names = suggestedNameInfo.names;
            if (names.length > 0 && !((String)(name = names[0])).equals(newName = InlineMethodConflictSolver.suggestNewName((String)name, null, parent, new String[0]))) {
                return new String[]{newName};
            }
            return names;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

