/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.control;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class ControlStructureFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement leaf;
        int offset = context.getTextRange().getStartOffset();
        PsiElement prevSibling = context.getPrevSibling();
        if (context.getParent() instanceof GrReferenceElement && prevSibling != null && prevSibling.getNode() != null) {
            ASTNode node = prevSibling.getNode();
            return !GroovyTokenTypes.DOTS.contains(node.getElementType());
        }
        if (GroovyCompletionUtil.isNewStatement(context, true) && (leaf = GroovyCompletionUtil.getLeafByOffset(offset - 1, context)) != null) {
            PsiElement parent = leaf.getParent();
            if (parent instanceof GroovyFile || parent instanceof GrOpenBlock || parent instanceof GrClosableBlock) {
                return true;
            }
            if (parent instanceof GrCaseSection) {
                return true;
            }
        }
        if (context.getParent() != null) {
            PsiElement parent = context.getParent();
            if (parent instanceof GrExpression && parent.getParent() instanceof GroovyFile) {
                return true;
            }
            if (parent instanceof GrReferenceExpression) {
                PsiElement elem;
                PsiElement superParent = parent.getParent();
                if (superParent instanceof GrOpenBlock || superParent instanceof GrClosableBlock || superParent instanceof GrCaseSection || superParent instanceof GrIfStatement || superParent instanceof GrForStatement || superParent instanceof GrWhileStatement) {
                    return true;
                }
                if (superParent instanceof GrExpression && ((elem = superParent.getParent()) instanceof GrCaseSection || elem instanceof GrLoopStatement || elem instanceof GrIfStatement)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "Control structure keywords filter";
    }
}

