/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyInsertHandler
implements InsertHandler<LookupElement> {
    private static final String CLOSURE_CLASS = "groovy.lang.Closure";

    public void handleInsert(InsertionContext context, LookupElement item) {
        Object obj = item.getObject();
        if (obj instanceof PsiMethod) {
            PsiElement parent;
            PsiMethod method = (PsiMethod)obj;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            if (context.getCompletionChar() == '\t') {
                GroovyInsertHandler.handleOverwrite(editor.getCaretModel().getOffset(), document);
            }
            CaretModel caretModel = editor.getCaretModel();
            int offset = context.getStartOffset() + method.getName().length();
            PsiFile file = PsiDocumentManager.getInstance((Project)method.getProject()).getPsiFile(document);
            PsiElement elementAt = file.findElementAt(context.getStartOffset());
            PsiElement psiElement = parent = elementAt != null ? elementAt.getParent() : null;
            if (parent instanceof GrReferenceExpression && ((GrReferenceExpression)parent).getDotTokenType() == GroovyElementTypes.mMEMBER_POINTER) {
                return;
            }
            if (parent instanceof GrAnnotationNameValuePair || parent.getParent() instanceof GrAnnotationNameValuePair) {
                document.insertString(offset, (CharSequence)" = ");
                caretModel.moveToOffset(offset + 3);
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)elementAt, GrImportStatement.class) != null) {
                return;
            }
            if (parameters.length == 1 && CLOSURE_CLASS.equals(parameters[0].getType().getCanonicalText())) {
                document.insertString(offset, (CharSequence)" {}");
                caretModel.moveToOffset(offset + 2);
                return;
            }
            PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)method.getProject());
            docManager.commitDocument(document);
            PsiFile psiFile = docManager.getPsiFile(document);
            if (GroovyInsertHandler.isExpressionStatement(psiFile, context.getStartOffset()) && PsiType.VOID.equals(method.getReturnType()) && '(' != context.getCompletionChar() && parameters.length > 0) {
                TailType.insertChar((Editor)editor, (int)offset, (char)' ');
                return;
            }
            new MethodParenthesesHandler(method, true).handleInsert(context, item);
            return;
        }
        if (obj instanceof String && !"assert".equals(obj)) {
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            if (context.getCompletionChar() == '\t') {
                GroovyInsertHandler.handleOverwrite(editor.getCaretModel().getOffset(), document);
            }
        } else if (obj instanceof PsiClass) {
            PsiClass clazz = (PsiClass)obj;
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)clazz.getProject()).getPsiFile(document);
            PsiElement elementAt = file.findElementAt(context.getStartOffset());
            CaretModel caretModel = editor.getCaretModel();
            int offset = context.getStartOffset() + clazz.getName().length();
            String text = document.getText();
            PsiElement parent = elementAt.getParent();
            if (parent instanceof GrCodeReferenceElement && parent.getParent() instanceof GrNewExpression && (offset == text.length() || !text.substring(offset).trim().startsWith("("))) {
                PsiMethod[] methods;
                document.insertString(offset, (CharSequence)"()");
                for (PsiMethod method : methods = clazz.getConstructors()) {
                    if (method.getParameterList().getParameters().length <= 0) continue;
                    caretModel.moveToOffset(offset + 1);
                    return;
                }
                caretModel.moveToOffset(offset + 2);
                return;
            }
        }
        GroovyInsertHandler.addTailType(item).processTail(context.getEditor(), context.getTailOffset());
    }

    private static boolean isExpressionStatement(PsiFile psiFile, int offset) {
        PsiElement elementAt = psiFile.findElementAt(offset);
        if (elementAt == null) {
            return false;
        }
        GrExpression expr = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, GrExpression.class);
        if (expr == null) {
            return false;
        }
        return expr.getParent() instanceof GrControlFlowOwner;
    }

    private static void handleOverwrite(int offset, Document document) {
        int i;
        CharSequence sequence = document.getCharsSequence();
        for (i = offset; i < sequence.length() && (Character.isJavaIdentifierPart(sequence.charAt(i)) || sequence.charAt(i) == '\''); ++i) {
        }
        document.deleteString(offset, i);
    }

    private static TailType addTailType(LookupElement item) {
        if ("default".equals(item.toString())) {
            return TailType.CASE_COLON;
        }
        String[] withSpace = new String[]{"private", "public", "protected", "static", "transient", "abstract", "native", "volatile", "strictfp", "boolean", "byte", "char", "short", "int", "float", "long", "double", "void", "new", "try", "while", "with", "switch", "for", "return", "throw", "throws", "assert", "synchronized", "package", "class", "interface", "enum", "extends", "implements", "case", "catch", "finally", "else", "instanceof", "import", "final"};
        if (Arrays.asList(withSpace).contains(item.toString())) {
            return TailType.SPACE;
        }
        return TailType.NONE;
    }
}

