/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyClassNameInsertHandler
implements AllClassesGetter.ClassNameInsertHandler {
    public AllClassesGetter.ClassNameInsertHandlerResult handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
        PsiFile file = context.getFile();
        assert (GroovyFileType.GROOVY_LANGUAGE.equals(file.getLanguage()));
        Editor editor = context.getEditor();
        int endOffset = editor.getCaretModel().getOffset();
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(endOffset - 1), GrImportStatement.class, (boolean)false) != null) {
            return AllClassesGetter.ClassNameInsertHandlerResult.INSERT_FQN;
        }
        PsiElement position = file.findElementAt(endOffset - 1);
        if (GroovyClassNameInsertHandler.isInVariable(position)) {
            Project project = context.getProject();
            PsiClass psiClass = item.getObject();
            if (!psiClass.isValid()) {
                return AllClassesGetter.ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE;
            }
            String qname = psiClass.getQualifiedName();
            String shortName = psiClass.getName();
            if (qname == null) {
                return AllClassesGetter.ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedClass(shortName, position);
            if (aClass == null) {
                ((GroovyFileBase)file).addImportForClass(psiClass);
                new GroovyInsertHandler().handleInsert(context, (LookupElement)item);
                return AllClassesGetter.ClassNameInsertHandlerResult.REFERENCE_CORRECTED;
            }
            if (aClass == psiClass) {
                new GroovyInsertHandler().handleInsert(context, (LookupElement)item);
                return AllClassesGetter.ClassNameInsertHandlerResult.REFERENCE_CORRECTED;
            }
        }
        return AllClassesGetter.ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE;
    }

    private static boolean isInVariable(PsiElement position) {
        GrVariable variable = (GrVariable)PsiTreeUtil.getParentOfType((PsiElement)position, GrVariable.class);
        return variable != null && variable.getTypeElementGroovy() == null && position == variable.getNameIdentifierGroovy();
    }
}

