/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.utils;

import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    private static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    private static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int EXPONENTIAL_PRECEDENCE = 5;
    public static final int MULTIPLICATIVE_PRECEDENCE = 6;
    private static final int ADDITIVE_PRECEDENCE = 7;
    public static final int SHIFT_PRECEDENCE = 8;
    private static final int RELATIONAL_PRECEDENCE = 9;
    public static final int EQUALITY_PRECEDENCE = 10;
    private static final int BINARY_AND_PRECEDENCE = 11;
    private static final int BINARY_XOR_PRECEDENCE = 12;
    private static final int BINARY_OR_PRECEDENCE = 13;
    public static final int AND_PRECEDENCE = 14;
    public static final int OR_PRECEDENCE = 15;
    public static final int CONDITIONAL_PRECEDENCE = 16;
    private static final int ASSIGNMENT_PRECEDENCE = 17;
    private static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    private ParenthesesUtils() {
    }

    @Nullable
    public static GrExpression stripParentheses(@Nullable GrExpression expression) {
        GrExpression parenthesized = expression;
        while (parenthesized instanceof GrParenthesizedExpression) {
            GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)parenthesized;
            parenthesized = parenthesizedExpression.getOperand();
        }
        return parenthesized;
    }

    public static int getPrecendence(GrExpression expression) {
        GrBinaryExpression binaryExpression;
        IElementType sign;
        if (expression instanceof GrThisReferenceExpression || expression instanceof GrLiteral || expression instanceof GrSuperReferenceExpression) {
            return 0;
        }
        if (expression instanceof GrReferenceExpression) {
            GrReferenceExpression referenceExpression = (GrReferenceExpression)expression;
            if (referenceExpression.getQualifierExpression() != null) {
                return 1;
            }
            return 0;
        }
        if (expression instanceof GrMethodCallExpression) {
            return 1;
        }
        if (expression instanceof GrTypeCastExpression || expression instanceof GrNewExpression) {
            return 4;
        }
        if (expression instanceof GrPostfixExpression) {
            return 2;
        }
        if (expression instanceof GrUnaryExpression) {
            return 3;
        }
        if (expression instanceof GrBinaryExpression && (sign = (binaryExpression = (GrBinaryExpression)expression).getOperationTokenType()) != null) {
            return ParenthesesUtils.precedenceForBinaryOperator(sign);
        }
        if (expression instanceof GrConditionalExpression) {
            return 16;
        }
        if (expression instanceof GrAssignmentExpression) {
            return 17;
        }
        if (expression instanceof GrParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int precedenceForBinaryOperator(@NotNull IElementType sign) {
        if (sign == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/utils/ParenthesesUtils.precedenceForBinaryOperator must not be null");
        }
        return s_binaryOperatorPrecedence.get(sign);
    }

    static {
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mPLUS, 7);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mMINUS, 7);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mSTAR, 6);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mDIV, 6);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mMOD, 6);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mSTAR_STAR, 5);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mLAND, 14);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mLOR, 15);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mBAND, 11);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mBOR, 13);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mBXOR, 12);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mGT, 9);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mGE, 9);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mLT, 9);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mLE, 9);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mEQUAL, 10);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mNOT_EQUAL, 10);
        s_binaryOperatorPrecedence.put(GroovyTokenTypes.mCOMPARE_TO, 10);
    }
}

