/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;

public class ReplaceAbstractClassInstanceByMapIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/style/ReplaceAbstractClassInstanceByMapIntention.getElementPredicate must not return null");
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/style/ReplaceAbstractClassInstanceByMapIntention.processIntention must not be null");
        }
        Project project = psiElement.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        GrNewExpression newExpr = (GrNewExpression)psiElement;
        GrCodeReferenceElement ref = newExpr.getReferenceElement();
        PsiElement resolved = ref.resolve();
        assert (resolved instanceof PsiClass);
        GrAnonymousClassDefinition anonymous = newExpr.getAnonymousClassDefinition();
        assert (anonymous != null);
        GrTypeDefinitionBody body = anonymous.getBody();
        HashMap myMethodToBodyMap = new HashMap();
        if (body != null) {
            for (PsiElement element : body.getChildren()) {
                GrOpenBlock block;
                if (!(element instanceof GrMethod) || (block = ((GrMethod)element).getBlock()) == null) continue;
                ArrayList<PsiElement> list = new ArrayList<PsiElement>();
                for (PsiElement child : block.getChildren()) {
                    if (child == block.getLBrace() || child == block.getRBrace()) continue;
                    list.add(child);
                }
                myMethodToBodyMap.put((Object)((GrMethod)element), list);
            }
        }
        PsiClass iface = (PsiClass)resolved;
        Collection<CandidateInfo> collection = GroovyOverrideImplementUtil.getMethodsToImplement(anonymous);
        for (CandidateInfo info : collection) {
            myMethodToBodyMap.put((Object)((PsiMethod)info.getElement()), Collections.emptyList());
        }
        if (myMethodToBodyMap.size() == 1) {
            ReplaceAbstractClassInstanceByMapIntention.createSingleMethodWrapper(project, iface, newExpr, (HashMap<PsiMethod, List<PsiElement>>)myMethodToBodyMap);
        } else {
            ReplaceAbstractClassInstanceByMapIntention.createMultipleMethodWrapper(project, iface, newExpr, (HashMap<PsiMethod, List<PsiElement>>)myMethodToBodyMap);
        }
    }

    private static void createMultipleMethodWrapper(Project project, PsiClass iface, GrNewExpression newExpression, HashMap<PsiMethod, List<PsiElement>> methodToBodyMap) throws IncorrectOperationException {
        ArrayList<PsiType> typesToImport = new ArrayList<PsiType>();
        StringBuffer buffer = new StringBuffer();
        int length = methodToBodyMap.size();
        buffer.append("[");
        Iterator iterator = methodToBodyMap.keySet().iterator();
        if (iterator.hasNext()) {
            buffer.append("\n");
            ReplaceAbstractClassInstanceByMapIntention.appendMethodEntry((PsiMethod)iterator.next(), typesToImport, buffer, methodToBodyMap);
        }
        while (iterator.hasNext()) {
            buffer.append(",\n");
            ReplaceAbstractClassInstanceByMapIntention.appendMethodEntry((PsiMethod)iterator.next(), typesToImport, buffer, methodToBodyMap);
        }
        if (length > 0) {
            buffer.append("\n");
        }
        buffer.append("]");
        buffer.append(" as ").append(iface.getName());
        ReplaceAbstractClassInstanceByMapIntention.createAndAdjustNewExpression(project, newExpression, typesToImport, buffer);
    }

    private static void appendMethodEntry(PsiMethod method, ArrayList<PsiType> typesToImport, StringBuffer buffer, HashMap<PsiMethod, List<PsiElement>> methodToBodyMap) {
        buffer.append(method.getName()).append(":").append(" ");
        ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod(method, buffer, typesToImport, methodToBodyMap);
    }

    private static void createSingleMethodWrapper(Project project, PsiClass iface, GrNewExpression newExpression, HashMap<PsiMethod, List<PsiElement>> methodToBodyMap) throws IncorrectOperationException {
        ArrayList<PsiType> typesToImport = new ArrayList<PsiType>();
        StringBuffer buffer = new StringBuffer();
        PsiMethod method = (PsiMethod)methodToBodyMap.keySet().iterator().next();
        ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod(method, buffer, typesToImport, methodToBodyMap);
        buffer.append(" as ").append(iface.getName());
        ReplaceAbstractClassInstanceByMapIntention.createAndAdjustNewExpression(project, newExpression, typesToImport, buffer);
    }

    private static void createAndAdjustNewExpression(Project project, GrNewExpression newExpression, ArrayList<PsiType> typesToImport, StringBuffer buffer) throws IncorrectOperationException {
        PsiFile file = newExpression.getContainingFile();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrExpression expr = factory.createExpressionFromText(buffer.toString());
        GrExpression safeTypeExpr = newExpression.replaceWithExpression(expr, false);
        if (file instanceof GroovyFileBase) {
            GroovyFileBase fileBase = (GroovyFileBase)file;
            final ArrayList unresolved = new ArrayList();
            safeTypeExpr.accept(new GroovyElementVisitor(){

                @Override
                public void visitElement(GroovyPsiElement element) {
                    for (PsiElement psiElement : element.getChildren()) {
                        if (!(psiElement instanceof GroovyPsiElement)) continue;
                        ((GroovyPsiElement)psiElement).accept(this);
                    }
                }

                @Override
                public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                    String name = refElement.getReferenceName();
                    if (refElement.getQualifier() == null && refElement.resolve() == null && name != null) {
                        unresolved.add(refElement);
                    }
                }
            });
            for (PsiType type : typesToImport) {
                if (!(type instanceof PsiClassType)) continue;
                PsiClass clazz = ((PsiClassType)type).resolve();
                for (GrCodeReferenceElement element : unresolved) {
                    if (clazz == null || clazz.getName() == null || !clazz.getName().equals(element.getReferenceName())) continue;
                    fileBase.addImportForClass(clazz);
                }
            }
        }
    }

    private static void appendClosureTextByMethod(PsiMethod method, StringBuffer buffer, ArrayList<PsiType> typesToImport, HashMap<PsiMethod, List<PsiElement>> methodToBodyMap) {
        PsiParameterList list = method.getParameterList();
        buffer.append("{ ");
        PsiParameter[] parameters = list.getParameters();
        HashSet<String> generatedNames = new HashSet<String>();
        if (parameters.length > 0) {
            PsiParameter first = parameters[0];
            PsiType type = first.getType();
            typesToImport.add(type);
            buffer.append(type.getPresentableText()).append(" ");
            buffer.append(ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, first, type));
        }
        for (int i = 1; i < parameters.length; ++i) {
            buffer.append(", ");
            PsiParameter param = parameters[i];
            PsiType type = param.getType();
            typesToImport.add(type);
            buffer.append(type.getPresentableText()).append(" ");
            String name = ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, param, type);
            buffer.append(name);
        }
        if (parameters.length > 0) {
            buffer.append(" ->\n");
        }
        for (PsiElement element : (List)methodToBodyMap.get((Object)method)) {
            buffer.append(element.getText()).append("\n");
        }
        buffer.append(" }");
    }

    private static String createName(Set<String> generatedNames, PsiParameter param, PsiType type) {
        String name = param.getName();
        if (name == null) {
            name = ReplaceAbstractClassInstanceByMapIntention.generateNameByType(type, generatedNames);
            assert (name != null);
        }
        generatedNames.add(name);
        return name;
    }

    private static String generateNameByType(PsiType type, Set<String> set) {
        String text = type.getPresentableText();
        ArrayList<String> strings = GroovyNamesUtil.camelizeString(text);
        assert (strings.size() > 0);
        String last = strings.get(strings.size() - 1).toLowerCase();
        int i = 1;
        String name = last;
        while (set.contains(name)) {
            name = last + i;
            ++i;
        }
        return name;
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            if (element instanceof GrNewExpression) {
                GrNewExpression newExpression = (GrNewExpression)element;
                GrAnonymousClassDefinition anonymous = newExpression.getAnonymousClassDefinition();
                if (newExpression.getQualifier() == null && anonymous != null && anonymous.getFields().length == 0) {
                    return true;
                }
            }
            return false;
        }
    }
}

